<?php
    namespace Encuesta;
    class Pregunta{
        private int $id;
        private ?Encuesta $encuesta;
        private string $nombre;
        private int $tipoDePregunta;
        private ?string $textoORutaArchivo;
        private bool $tieneArchivo;
        private bool $esPregenerado;
        private int $duracion;
        private ?int $maximoIntentos;
        public function __construct(int $id, ?Encuesta $encuesta, string $nombre, int $tipoDePregunta, ?string $textoORutaArchivo, bool $tieneArchivo, bool $esPregenerado, int $duracion, ?int $maximoIntentos){
            $this->id = $id;
            $this->encuesta = $encuesta;
            $this->nombre = $nombre;
            $this->tipoDePregunta = $tipoDePregunta;
            $this->textoORutaArchivo = $textoORutaArchivo;
            $this->tieneArchivo = $tieneArchivo;
            $this->esPregenerado = $esPregenerado;
            $this->duracion = $duracion;
            $this->maximoIntentos = $maximoIntentos;
        }
        public function toAssociativeArray():array{
            $resp = array();
            $resp["id"] = $this->id;
            $resp["nombre"] = $this->nombre;
            $resp["encuesta"] = ($this->encuesta != null?$this->$encuesta->toAssociativeArray():null);
            $resp["tipoDePregunta"] = $this->tipoDePregunta;
            $resp["textoORutaArchivo"] = $this->textoORutaArchivo;
            $resp["tieneArchivo"] = $this->tieneArchivo;
            $resp["esPregenerado"] = $this->esPregenerado;
            $resp["duracion"] = $this->duracion;
            $resp["maximoIntentos"] = $this->maximoIntentos;          
            return $resp;
        }
        public function getId():int{
            return $this->id;
        }
        public function getEncuesta():?Encuesta{
            return $this->encuesta;
        }
        public function setEncuesta(?Encuesta $encuesta):void{
            $this->encuesta = $encuesta;
        }
        public function getNombre():string{
            return $this->nombre;
        }
    }
?>