<?php

require_once "Cliente.php";
require_once RUTA_APP . 'Conexion.php';

class ExtrasConfig {

    private $id;
    private $cliente;
    private $label;
    private $url;
    private $script;
    private $icon;

    function __construct(
        $id,
        $cliente,
        $label,
        $url,
        $script,
        $icon = ""
    )
    {
        $this->id = $id;
        $this->cliente = $cliente;
        $this->label = $label;
        $this->url = $url;
        $this->script = $script;
        $this->icon = $icon;
    }

    public static function getById($id) {
        $res = NULL;
        $con = getConnection();

        $result = sv_mysqli_query($con, "SELECT * FROM dialvox_cliente_extras WHERE id=$id LIMIT 1");
        if ($row = sv_mysqli_fetch_array($result)) {
            $res = new ExtrasConfig(
                $row["id"],
                $row["cliente"],
                $row["label"],
                $row["url"],
                $row["script"],
                $row["icon"]
            );
        }

        sv_mysqli_close($con);
        return $res;
    }

    public static function getAllByCliente($cliente, $toJson = FALSE, $assoc = FALSE) {

        $res = array();
        $con = getConnection();

        $id_cliente = $cliente;
        if ($cliente instanceof Cliente) {
            $id_cliente = $cliente->getId();
        }

        $result = sv_mysqli_query($con, "SELECT * FROM dialvox_cliente_extras WHERE cliente='$id_cliente'");
        while ($row = sv_mysqli_fetch_array($result)) {
            $obj = new ExtrasConfig(
                $row["id"],
                $row["cliente"],
                $row["label"],
                $row["url"],
                $row["script"],
                $row["icon"]
            );
            if ($assoc) {
                if ($toJson) {
                    $res[$row["label"]] = $obj->toJSON();
                } else {
                    $res[$row["label"]] = $obj;
                }
            } else {
                if ($toJson) {
                    array_push($res, $obj->toJSON());
                } else {
                    array_push($res, $obj);
                }
            }
        }

        sv_mysqli_close($con);
        return $res;
    }

    public static function insert(
        $cliente,
        $label,
        $url,
        $script,
        $icon
    ) {
        $res = NULL;
        $con = getConnection();

        $id_cliente = $cliente;
        if ($cliente instanceof Cliente) {
            $id_cliente = $cliente->getId();
        }

        $stmt = $con->prepare("INSERT INTO dialvox_cliente_extras(cliente,label,url,script,icon) VALUES (?,?,?,?,?)");
        $stmt->bind_param(
            "sssss",
            $id_cliente,
            $label,
            $url,
            $script,
            $icon
        );

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    public static function update(
        $id,
        $label,
        $url,
        $script,
        $icon
    ) {
        $res = NULL;
        $con = getConnection();

        $stmt = $con->prepare("UPDATE dialvox_cliente_extras SET label=?,url=?,script=?,icon=? WHERE id=?");
        $stmt->bind_param(
            "sssss",
            $label,
            $url,
            $script,
            $icon,
            $id
        );

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    public static function delete($id) {
        $res = NULL;
        $con = getConnection();

        $stmt = $con->prepare("DELETE FROM dialvox_cliente_extras WHERE id=?");
        $stmt->bind_param("i", $id);

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    function toJSON() {
        $json = array();

        if ($this->cliente instanceof Cliente) {
            $json["Cliente"] = $this->cliente->toJSON();
        } else {
            $json["Cliente"] = $this->cliente;
        }

        $json["Id"] = $this->id;
        $json["Label"] = $this->label;
        $json["URL"] = $this->url;
        $json["Script"] = $this->script;
        $json["Icon"] = $this->icon;

        return $json;
    }

}

?>