function sweetConfirm(message) {
    return Swal.fire({
        type: "question",
        title: i18n.gettext("¿Estas seguro?"),
        text: message,
        showCancelButton: true,
        showConfirmButton: true

    })
}

function sweetSuccesEdit() {
    Swal.fire({
        type: "success",
        title: i18n.gettext("Registro actualizado"),
        html: i18n.gettext("Se han guardado exitosamente los cambios")
    })
}

function sweetSuccessAdd() {
    Swal.fire({
        type: "success",
        title: i18n.gettext("Registro exitoso"),
        html: i18n.gettext("Se ha guardado con éxito su nuevo registro")
    })
}
function sweetSuccessCustom(message) {
    Swal.fire({
        type: "success",
        title: i18n.gettext("¡Exito!"),
        html: message
    })
}
function sweetSuccessDelete() {
    Swal.fire({
        type: "success",
        title: i18n.gettext("¡Eliminado!"),
        html: i18n.gettext("Registro eliminado con éxito")
    })
}

function sweetFail() {
    Swal.fire({
        type: "error",
        title: i18n.gettext("Algo ha salido mal"),
        html: i18n.gettext("Ha ocurrido un error al tratar de completar la acción anterior")
    })
}

function sweetFailCustom(text) {
    let parts = text.split("<br>")[0]
    if (text.split("<br>")[1]) {
        parts += "<br><span class='text-danger font-weight-bold'> Error #"
        parts += text.split("<br>")[1]
        parts += "</span>"
    }
    Swal.fire({
        type: "error",
        title: i18n.gettext("Algo ha salido mal"),
        html: parts
    })
}

function sweetWaiterCustom(text) {
    SweetAlert.fire({
        type: "info",
        title: i18n.gettext("Procesando"),
        html: text,
        onBeforeOpen: () => {
            Swal.showLoading()
        }
    });
}

function sweetWaiterMessages() {
    SweetAlert.fire({
        type: "info",
        title: i18n.gettext("Procesando"),
        html: i18n.gettext("Enviando tus mensajes"),
        onBeforeOpen: () => {
            Swal.showLoading()
        }
    });
}

function sweetSuccessCustom(text) {
    Swal.fire({
        type: "success",
        title: i18n.gettext("¡Éxito!"),
        html: text
    })
}