<script>
    // Emite el evento submit al hacer click en el boton de enviar
    Vue.component('modal-dialvox', {
        methods: {
            toggle() {
                this.$emit("closed")
                this.$emit("input", !this.value)
            }
        },
        props: {
            value: {
                type: Boolean,
                default: false
            }, // Prop para mostart el modal
            disabled: {
                type: Boolean,
                default: false
            }, // Prop para inhabiliar el valor de enviar
            send: {
                type: String,
                default: "Enviar"
            }, // Texto del boton de envio, 'Enviar' por default
            cancel: {
                type: String,
                default: "Cancelar"
            }, // Texto del boton cancelar, 'Cancelar' por default. Cierrar el modal
            medium: {
                type: Boolean,
                default: false
            }, // Tamaño del modal, al 60% de la pantalla
            small: {
                type: Boolean,
                default: false
            }, // Tamaño del modal, al 30% de la pantalla
            large: {
                type: Boolean,
                default: false,
            }, // Tamano del modal, al 80% de la pantalla
        },
        watch: {
            value(val, old) {
                let ins = M.Modal.getInstance(this.$refs.modal)
                if (val) {
                    ins.open()
                    this.$refs.modal.scrollTo(0, 0)
                } else {
                    ins.close()
                }
            },
        },
        mounted() {
            let self = this
            let elem = this.$refs.modal
            let instance = M.Modal.init(elem, {
                onCloseEnd: function () {
                    self.$emit("input", false)
                },
            })
            if (this.show) {
                M.Modal.getInstance(this.$refs.modal).open()
            }

        },
        template: `<?php echo file_get_contents("modal.component.html", TRUE)?>`
    })
</script>