(function () {
	const app = new Vue({
		el: '#main',
		data() {
			return {
				options: [],
				ingroups: [],
				headersGeneral: [
					{ label: 'DID', key: 'did' },
					{ label: traducirFrase('Llamadas'), key: 'llamadas' },
				],
				headersFecha: [
					{ label: traducirFrase('Fecha'), key: 'date' },
					{ label: traducirFrase('Llamadas'), key: 'llamadas' },
				],
				headersHoras: [
					{ label: traducirFrase('Hora'), key: 'hora' },
					{ label: traducirFrase('Llamadas'), key: 'llamadas' },
				],
				registrosGeneral: [],
				registrosFecha: [],
				registrosHoras: [],
				archived: false,
			};
		},
		methods: {
			getFecha() {
				return $('#fechaReporte').val().split(' - ');
			},
			load() {
				const [fechaInicio, fechaFin] = this.getFecha();
				document.getElementById('spinner').style.display = 'block';
				console.log(this.ingroups)
				rget('ReporteEntranteDID/DIDReport', {
					fechaInicial: fechaInicio,
					fechaFinal: fechaFin ? fechaFin : fechaInicio,
					archived: this.archived ? 1 : 0,
					grupos: this.ingroups,
				})
					.then((r) => {
						gen_rpost('IVR/seleccionarTelefonosDID', {})
							.then((dids) => {
								console.log(dids);
								console.log(r);

								this.options = dids.TelefonosDID.map((v) => ({
									label: v.DIDExtension,
									value: v.id,
								}));

								const { DIDS, fechas, Hora } = r;
								const registrosGeneral = [];
								const registrosFechas = [];
								const registrosHoras = [];

								Object.keys(DIDS).forEach((keyDid) => {
									registrosGeneral.push({
										did: keyDid,
										llamadas: DIDS[keyDid],
									});
								});

								Object.keys(fechas).forEach((keyFechas) => {
									registrosFechas.push({
										date: keyFechas,
										llamadas: fechas[keyFechas],
									});
								});

								Object.keys(Hora).forEach((keyHora) => {
									const hora = keyHora < 10 ? '0' + keyHora : keyHora

									registrosHoras.push({
										hora: `${hora}:00:00 - ${hora}:14:59`,
										llamadas: Hora[keyHora][0],
									})

									registrosHoras.push({
										hora: `${hora}:15:00 - ${hora}:29:59`,
										llamadas: Hora[keyHora][15],
									})

									registrosHoras.push({
										hora: `${hora}:30:00 - ${hora}:44:59`,
										llamadas: Hora[keyHora][30],
									})

									registrosHoras.push({
										hora: `${hora}:45:00 - ${hora}:59:59`,
										llamadas: Hora[keyHora][45],
									})

								})

								this.registrosGeneral = registrosGeneral;
								this.registrosFecha = registrosFechas;
								this.registrosHoras = registrosHoras;

								setTimeout(
									() => $('#ingroupReporte').formSelect(),
									1000
								);
								document.getElementById(
									'spinner'
								).style.display = 'none';
							})
							.catch((err) => {
								console.log(err);
							});
					})
					.catch(console.log);
			},
			descargar() {
				const [fechaInicio, fechaFin] = this.getFecha();
				window.location.href = `${DV_MODULOS}/ReporteEntranteDID/DIDReport?fechaInicial=${fechaInicio}&fechaFinal=${fechaFin ? fechaFin : fechaInicio
					}&archived=${this.archived ? 1 : 0}&grupos=${this.ingroups
					}&csv=1`;
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			$('#fechaReporte').val(new Date().toISOString().split('T').shift());
			this.load();
		},
	});
})();
