<modal-dialvox v-model="targets.report" :send="traducirFrase('Guardar')" small @submit="downloadReport('downloadReport', 'download')">
    <h4>{{traducirFrase("Descargar Reporte")}}</h4>
    <br>
    <div class="container">
        <div class="row px-3">
            <div class="col s12">
                <p>
                    {{traducirFrase("Selecciona el rango de fechas para el reporte de lista. Si no seleccionas fechas se descargara el reporte")}} <span class="red-text">{{traducirFrase("sin filtro de fechas.")}}</span>
                </p>
            </div>
            <div class="col s12">
                <p class="radioReporte">
                    <label>
                        <input name="group1" type="radio" value="general" v-model="descargarReporte.tipoDeReporte" />
                        <span>{{traducirFrase("Reporte general")}}</span>
                    </label>
                </p>
                <p class="radioReporte">
                    <label>
                        <input name="group1" type="radio" value="detallado" v-model="descargarReporte.tipoDeReporte" />
                        <span>{{traducirFrase("Reporte detallado")}}</span>
                    </label>
                </p>
            </div>
        </div>
        <div class="input-field col s12">
            <label class="active">{{traducirFrase("Campaña")}}</label>
            <select id="selectCampanas" multiple v-model="campana">
                <option disabled>Selecciona una campaña</option>
                <option v-for="val in campanas" :value="val.value"> {{ val.label }} </option>
            </select>
        </div>
        <div class="col s12">
            <label>
                Si no seleccionas ninguna campaña se descargara el reporte de todas las campañas.
            </label>
        </div>
        <div class="col s12">
            <label for="downloadDateEncuesta">{{traducirFrase("Fecha")}}</label>
            <input type="text" autocomplete="off" start-date="new Date()" class=" datepicker-here" data-range="true" data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd" data-language="<?= $idioma; ?>" class="datepicker-here" id="downloadDateEncuesta" />
        </div>
        <div v-if="descargarReporte.progressBar" class="col s12 justify-content-center">
            <div class="progress">
                <div class="indeterminate"></div>
            </div>
        </div>
    </div>
</modal-dialvox>

<script>
    $(document).ready(function() {
        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth() + 1; //January is 0!
        var yyyy = today.getFullYear();
        if (dd < 10) {
            dd = '0' + dd;
        }
        if (mm < 10) {
            mm = '0' + mm;
        }
        var today = yyyy + '-' + mm + '-' + dd;
        $('#downloadDateList').val(today + " - " + today);

    });
</script>