<?php
$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}
?>
<modal-dialvox v-model="targets.editOld" :send="traducirFrase('Guardar')" small @submit="add('updateCallTime', 'editOld')" :disabled="!validForm">
    <h4>{{traducirFrase("Editar horario de llamada")}}</h4>
    <br><br>
    <div class="container">
        <div class="row">
            <div v-for="field in generalFields" class="input-field">
                <input v-if="field.type === 'text'" type="text" v-model="one[field.key]" :placeholder="traducirFrase(field.label)">
                <select v-if="field.type === 'select'" class="browser-default" v-model="one[field.key]" v-bind:placeholder="traducirFrase(field.label)">
                    <option v-for="opt in getOptionsByField(field)" :key="opt.value" :value="opt.value">
                        {{opt.label}}
                    </option>
                </select>
                <input
                    v-if="field.type === 'datepicker'" 
                    type="text" 
                    autocomplete="off" 
                    start-date="new Date()" 
                    class="datepicker-here" 
                    data-date-format="yyyy-mm-dd"
                    data-language="<?= $idioma; ?>"
                    class="datepicker-here"
                    :id="field.key+'_edit_datepicker'"
                    :placeholder="traducirFrase(field.label)"
                />
                <label class="active">{{traducirFrase(field.label)}}</label>
                <span class="helper-text" v-if="field.hint && field.hint !== ''">{{ traducirFrase(field.hint) }}</span>
            </div>
        </div>
    </div>
</modal-dialvox>
