<?php

require_once "BASEPATH.php";

class ReporteAgenteStatus extends MY_Controller
{
    public function getAgenteReport()
    {
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $con = getConnection();
            $fechaInicio = limpia($_GET["fechaInicio"]);
            $fechaFin = limpia($_GET["fechaFin"]);
            $campanas = $_GET["campanas"];
            $archived = false;
            if (isset($_GET["archived"]) && limpia($_GET["archived"]) == 1) {
                $archived = true;
            }
            $campanias = "";
            if (count($campanas) != 0) {
                foreach ($campanas as $val) {
                    $campanias .= "'$val',";
                }
                $campanias = substr($campanias, 0, -1);
            }
            $sal = array();
            $sal["Estado"] = "ok";
            $usuarios = array();
            $query = "SELECT distinct full_name,vicidial_users.user from vicidial_users,vicidial_agent_log where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_agent_log.user and status is not null and campaign_id IN($campanias)  order by full_name asc";

            if ($archived) {
                $query = "SELECT distinct full_name,vicidial_users.user from vicidial_users,vicidial_agent_log_archive where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_agent_log_archive.user and status is not null and campaign_id IN($campanias)  order by full_name asc";
            }

            $result = sv_mysqli_query($con, $query);
            while ($nombres = sv_mysqli_fetch_array($result)) {
                $usuarios[$nombres["user"]] = array();
                $usuarios[$nombres["user"]]["nombreCompleto"] = $nombres["full_name"];
            }
            $status = array();
            $query = "SELECT distinct status from vicidial_users,vicidial_agent_log where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_agent_log.user and campaign_id IN($campanias)  order by status";
            if ($archived) {
                $query = "SELECT distinct status from vicidial_users,vicidial_agent_log_archive where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_agent_log_archive.user and campaign_id IN($campanias)  order by status";
            }

            $result = sv_mysqli_query($con, $query);
            while ($stat = sv_mysqli_fetch_array($result)) {
                if (!empty($stat["status"])) {
                    $status[] = $stat["status"];
                    $query = "SELECT count(*) as calls,user,status from vicidial_agent_log where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00'  and status='" . $stat["status"] . "' and campaign_id IN($campanias) group by user,status order by user,status desc ";
                    if ($archived) {
                        $query = "SELECT count(*) as calls,user,status from vicidial_agent_log_archive where event_time <= '$fechaFin 23:59:59' and event_time >= '$fechaInicio 00:00:00'  and status='" . $stat["status"] . "' and campaign_id IN($campanias) group by user,status order by user,status desc ";
                    }

                    $result2 = sv_mysqli_query($con, $query);
                    while ($conteo = sv_mysqli_fetch_array($result2)) {
                        if (!isset($usuarios[$conteo["user"]]["status"])) {
                            $usuarios[$conteo["user"]]["status"] = array();
                        }
                        $usuarios[$conteo["user"]]["status"][$conteo["status"]] = $conteo["calls"];
                    }
                }
            }

            if (isset($_GET["csv"])) {
                $sal = array();
                $encabezados = array();
                $encabezados[] = $this->lang->line("header_1");
                $encabezados[] = $this->lang->line("header_2");
                $encabezados = array_merge($encabezados, $status);
                $sal[] = $encabezados;
                foreach ($usuarios as $user => $info) {
                    $fila = array();
                    $fila[] = $user;
                    $fila[] = $info["nombreCompleto"];

                    foreach ($status as $stat) {
                        $fila[] = isset($info["status"][$stat]) ? $info["status"][$stat] : 0;
                    }
                    $sal[] = $fila;

                }
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=ReporteDeAgentePorStatus(" . $fechaInicio . "-" . $fechaFin . ").csv");
                header("Pragma: no-cache");
                header("Expires: 0");
                $out = fopen('php://output', 'w');
                foreach ($sal as $fila) {
                    fputcsv($out, $fila);
                }
                fclose($out);
            } else {
                $sal["status"] = $status;
                $sal["usuarios"] = $usuarios;
                $this->output->set_output(json_encode($sal));
            }

        }

    }
    public function getAgenteInboundReport()
    {
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $con = getConnection();
            $fechaInicio = limpia($_GET["fechaInicio"]);
            $fechaFin = limpia($_GET["fechaFin"]);
            $campanas = $_GET["campanas"];
            $archived = false;
            if (isset($_GET["archived"]) && limpia($_GET["archived"]) == 1) {
                $archived = true;
            }

            $campanias = "";
            if (count($campanas) != 0) {
                foreach ($campanas as $val) {
                    $campanias .= "'$val',";
                }
                $campanias = substr($campanias, 0, -1);
            }
            $sal = array();
            $sal["Estado"] = "ok";
            $usuarios = array();
            $query = "SELECT distinct full_name,vicidial_users.user from vicidial_users,vicidial_closer_log where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_closer_log.user and status is not null and campaign_id IN($campanias)  order by full_name asc";
            if ($archived) {
                $query = "SELECT distinct full_name,vicidial_users.user from vicidial_users,vicidial_closer_log_archive where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_closer_log_archive.user and status is not null and campaign_id IN($campanias)  order by full_name asc";
            }
            $result = sv_mysqli_query($con, $query);
            while ($nombres = sv_mysqli_fetch_array($result)) {
                $usuarios[$nombres["user"]] = array();
                $usuarios[$nombres["user"]]["nombreCompleto"] = $nombres["full_name"];
            }
            $status = array();
            $query = "SELECT distinct status from vicidial_users,vicidial_closer_log where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_closer_log.user and campaign_id IN($campanias)  order by status";
            if ($archived) {
                $query = "SELECT distinct status from vicidial_users,vicidial_closer_log_archive where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00' and vicidial_users.user=vicidial_closer_log_archive.user and campaign_id IN($campanias)  order by status";
            }
            $result = sv_mysqli_query($con, $query);
            while ($stat = sv_mysqli_fetch_array($result)) {
                if (!empty($stat["status"])) {
                    $status[] = $stat["status"];
                    $query = "SELECT count(*) as calls,user,status from vicidial_closer_log where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00'  and status='" . $stat["status"] . "' and campaign_id IN($campanias) group by user,status order by user,status desc ";
                    if ($archived) {
                        $query = "SELECT count(*) as calls,user,status from vicidial_closer_log_archive where call_date <= '$fechaFin 23:59:59' and call_date >= '$fechaInicio 00:00:00'  and status='" . $stat["status"] . "' and campaign_id IN($campanias) group by user,status order by user,status desc ";

                    }
                    $result2 = sv_mysqli_query($con, $query);
                    while ($conteo = sv_mysqli_fetch_array($result2)) {
                        if (!isset($usuarios[$conteo["user"]]["status"])) {
                            $usuarios[$conteo["user"]]["status"] = array();
                        }
                        $usuarios[$conteo["user"]]["status"][$conteo["status"]] = $conteo["calls"];
                    }
                }
            }

            if (isset($_GET["csv"])) {
                $sal = array();
                $encabezados = array();
                $encabezados[] = "Usuario";
                $encabezados[] = "Nombre completo";
                $encabezados = array_merge($encabezados, $status);
                $sal[] = $encabezados;
                foreach ($usuarios as $user => $info) {
                    $fila = array();
                    $fila[] = $user;
                    if (isset($info["nombreCompleto"])) {
                        $fila[] = $info["nombreCompleto"];
                    } else {
                        $fila[] = "N/A";
                    }

                    foreach ($status as $stat) {
                        $fila[] = isset($info["status"][$stat]) ? $info["status"][$stat] : 0;
                    }
                    $sal[] = $fila;

                }
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=ReporteDeAgentePorStatus(" . $fechaInicio . "-" . $fechaFin . ").csv");
                header("Pragma: no-cache");
                header("Expires: 0");
                $out = fopen('php://output', 'w');
                foreach ($sal as $fila) {
                    fputcsv($out, $fila);
                }
                fclose($out);
            } else {
                $sal["status"] = $status;
                $sal["usuarios"] = $usuarios;
                $this->output->set_output(json_encode($sal));
            }

        }

    }

    public function index()
    {
        $this->load->view('reporteAgenteStatus/head');
        $this->load->view('reporteAgenteStatus/vw_reporte_agente_status');
    }
}
