<?php

require_once "BASEPATH.php";

class Pregunta extends MY_Controller
{

    public function getPreguntasSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('pregunta', "spanish");
                break;
            case "en":
                $this->lang->load('pregunta', "english");
                break;
            default:
                $this->lang->load('pregunta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_pregunta,nombre FROM dialvox_pregunta WHERE id_encuesta='$id_encuesta' ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getPreguntas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('pregunta', "spanish");
                break;
            case "en":
                $this->lang->load('pregunta', "english");
                break;
            default:
                $this->lang->load('pregunta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $pagina = limpia($_POST["pagina"]) - 1;
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_pregunta,nombre,tipoDePregunta,tipoDeRespuestas FROM dialvox_pregunta WHERE id_encuesta='$id_encuesta' LIMIT " . ($pagina * 10) . ",10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }

            $query = "SELECT COUNT(id_pregunta) AS CANT FROM dialvox_pregunta WHERE id_encuesta='$id_encuesta' ";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deletePregunta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('pregunta', "spanish");
                break;
            case "en":
                $this->lang->load('pregunta', "english");
                break;
            default:
                $this->lang->load('pregunta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $query = "DELETE FROM dialvox_pregunta WHERE id_encuesta='$id_encuesta' AND id_pregunta='$id_pregunta'";
            sv_mysqli_query($con, $query);
            $query = "DELETE FROM dialvox_respuesta WHERE id_pregunta='$id_pregunta'";
            sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function markAsFirstPregunta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('pregunta', "spanish");
                break;
            case "en":
                $this->lang->load('pregunta', "english");
                break;
            default:
                $this->lang->load('pregunta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $query = "UPDATE  dialvox_encuestas SET id_pregunta='$id_pregunta' WHERE id_encuesta='$id_encuesta' AND cliente='$cliente' ";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addPregunta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('pregunta', "spanish");
                break;
            case "en":
                $this->lang->load('pregunta', "english");
                break;
            default:
                $this->lang->load('pregunta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $tipoPregunta = limpia($_POST["tipoPregunta"]);
            $duracion = limpia($_POST["duracion"]);
            $nombre = limpia($_POST["nombre"]);

            if ($tipoPregunta == 1) {
                $numeroMaximoIntentos = limpia($_POST["numeroMaximoIntentos"]);
                $tipoDeRespuestas = limpia($_POST["tipoDeRespuestas"]);
                $tipoDeAccionDefecto = limpia($_POST["tipoDeAccionDefecto"]);
                $valorDeAccionDefecto = limpia($_POST["valorDeAccionDefecto"]);
                $tieneArchivo = limpia($_POST["tieneArchivoCondicional"]) == 1 ? 1 : 0;
                if ($tieneArchivo) {
                    $rutaDelArchivo = $_FILES["archivo"]["tmp_name"];
                    $rutaDelArchivoFinal = "/var/lib/asterisk/sounds/" . $_FILES["archivo"]["name"] . "_converted.wav";
                    exec("ffmpeg -i $rutaDelArchivo -acodec pcm_s16le -ar 8000 -sample_fmt s16 -ac 1 -framerate 2 -y $rutaDelArchivoFinal");

                    $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,duracion,maximoIntentos,tipoDeRespuestas,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta','" . basename($rutaDelArchivoFinal, ".wav") . "',1,'$duracion','$numeroMaximoIntentos','$tipoDeRespuestas','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                    sv_mysqli_query($con, $query);

                } else {
                    $texto = limpia($_POST["texto"]);

                    $voz = "google_es";

                    $esPregenerado = limpia($_POST["esPregenerado"]) ? 1 : 0;
                    if ($esPregenerado) {
                        $query = "SELECT voz from dialvox_encuestas WHERE id_encuesta='$id_encuesta'";
                        $result = sv_mysqli_query($con, $query);
                        if ($row = sv_mysqli_fetch_array($result)) {
                            $voz = $row["voz"];
                        }

                        $idAudio = 0;
                        $aleatorio = rand(10000, 2000000000);

                        $query = "SELECT id FROM bd_ivr.tbl_audio ORDER BY id DESC LIMIT 1";
                        $result = sv_mysqli_query($con, $query);
                        if ($row = sv_mysqli_fetch_array($result)) {
                            $idAudio = $row["id"];
                        }
                        $idAudio++;

                        $query = "INSERT INTO bd_ivr.tbl_audio(id,aleatorio,voz,mensaje,generado,cpuname) VALUES('$idAudio','$aleatorio','$voz','$texto','0',NULL)";
                        sv_mysqli_query($con, $query);

                        $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,esPregenerado,duracion,maximoIntentos,idAudio,tipoDeRespuestas,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta',NULL,0,1,'$duracion','$numeroMaximoIntentos','$idAudio','$tipoDeRespuestas','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                        sv_mysqli_query($con, $query);

                        echo mysqli_error($con);

                    } else {
                        $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,esPregenerado,duracion,maximoIntentos,tipoDeRespuestas,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta','$texto',0,0,'$duracion','$numeroMaximoIntentos','$tipoDeRespuestas','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                        sv_mysqli_query($con, $query);

                    }

                }
            } elseif ($tipoPregunta == 2) {
                $tipoDeAccionDefecto = limpia($_POST["tipoDeAccionDefecto"]);
                $valorDeAccionDefecto = limpia($_POST["valorDeAccionDefecto"]);
                $tieneArchivo = limpia($_POST["tieneArchivoCondicional"]) == 1 ? 1 : 0;
                if ($tieneArchivo) {
                    $rutaDelArchivo = $_FILES["archivo"]["tmp_name"];
                    $rutaDelArchivoFinal = "/var/lib/asterisk/sounds/" . $_FILES["archivo"]["name"] . "_converted.wav";
                    exec("ffmpeg -i $rutaDelArchivo -acodec pcm_s16le -ar 8000 -sample_fmt s16 -ac 1 -framerate 2 -y $rutaDelArchivoFinal");

                    $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,duracion,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta','" . basename($rutaDelArchivoFinal, ".wav") . "',1,'$duracion','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                    sv_mysqli_query($con, $query);

                } else {
                    $texto = limpia($_POST["texto"]);

                    $voz = "google_es";

                    $esPregenerado = limpia($_POST["esPregenerado"]) ? 1 : 0;
                    if ($esPregenerado) {
                        $query = "SELECT voz from dialvox_encuestas WHERE id_encuesta='$id_encuesta'";
                        $result = sv_mysqli_query($con, $query);
                        if ($row = sv_mysqli_fetch_array($result)) {
                            $voz = $row["voz"];
                        }

                        $idAudio = 0;
                        $aleatorio = rand(10000, 2000000000);

                        $query = "SELECT id FROM bd_ivr.tbl_audio ORDER BY id DESC LIMIT 1";
                        $result = sv_mysqli_query($con, $query);
                        if ($row = sv_mysqli_fetch_array($result)) {
                            $idAudio = $row["id"];
                        }
                        $idAudio++;

                        $query = "INSERT INTO bd_ivr.tbl_audio(id,aleatorio,voz,mensaje,generado,cpuname) VALUES('$idAudio','$aleatorio','$voz','$texto','0',NULL)";
                        sv_mysqli_query($con, $query);

                        $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,esPregenerado,duracion,idAudio,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta',NULL,0,1,'$duracion','$idAudio','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                        sv_mysqli_query($con, $query);

                    } else {
                        $query = "INSERT INTO dialvox_pregunta(id_encuesta,nombre,tipoDePregunta,textoORutaArchivo,tieneArchivo,esPregenerado,duracion,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoPregunta','$texto',0,0,'$duracion','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
                        sv_mysqli_query($con, $query);
                    }
                }
            }

            if ($tipoDeAccionDefecto == 3 && $valorDeAccionDefecto == -1) {
                $idPregunta = mysqli_insert_id($con);
                $query = "UPDATE dialvox_pregunta SET valorDeAccionDefecto=$idPregunta WHERE id_pregunta='$idPregunta'";
                sv_mysqli_query($con, $query);
            }

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getPreguntaDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $query = "SELECT * FROM dialvox_pregunta WHERE id_pregunta='$id_pregunta'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Pregunta"] = $row;
                $sal["Estado"] = "ok";

            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('pregunta/head');
        $this->load->view('pregunta/vw_categorias');
        $this->load->view('pregunta/foot');
    }
}
