<?php

require_once "BASEPATH.php";

class DashboardHistorico extends MY_Controller
{

    public function logout()
    {
        if (!empty($_SESSION["Usuario"])) {
            session_destroy();
            header('Location: ' . MODULOS . 'login');
        }
        header('Location: ' . MODULOS . 'login');
    }

    public function index()
    {
        $this->load->view('homeHistoric/head');
        $this->load->view('homeHistoric/vw_home');
        $this->load->view('homeHistoric/foot');
    }

    public function dameCampas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('dashboardhistorico', "spanish");
                break;
            case "en":
                $this->lang->load('dashboardhistorico', "english");
                break;
            default:
                $this->lang->load('dashboardhistorico', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $apiUser = USER_API;
            $apiPass = PASS_API;
            $campa = limpia($_POST["campana"]);

            $sal = array();
            $con = getConnection();

            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }

            $query = "SELECT * FROM asterisk.vicidial_campaigns;";

            $result = sv_mysqli_query($con, $query);

            $contador = 0;
            $datosxD = [];

            while ($row2 = sv_mysqli_fetch_array($result)) {

                $datosxD["datos"][$contador]["nombre"] = $row2["campaign_name"];
                $datosxD["datos"][$contador]["id"] = $row2["campaign_id"];
                $contador++;

            }

            $sal["estado"] = "ok";
            $this->output->set_output(json_encode($datosxD));
            //$this->output->set_output(json_encode($campa));
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function infoCampaHist()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('dashboardhistorico', "spanish");
                break;
            case "en":
                $this->lang->load('dashboardhistorico', "english");
                break;
            default:
                $this->lang->load('dashboardhistorico', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];

            $apiUser = USER_API;
            $apiPass = PASS_API;
            $campa = limpia($_POST["campana"]);

            $sal = [];
            $con = getConnection();
            if (isset($_POST["archived"]) && limpia($_POST["archived"]) == 1) {
                $archived = true;
            }

            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }

            $query = "SELECT * FROM asterisk.vicidial_campaigns;";

            $query2 = "(SELECT vicidial_statuses.status as statusu, vicidial_statuses.status_name as name FROM vicidial_statuses) " .
                "UNION (SELECT vicidial_campaign_statuses.status as statusu, vicidial_campaign_statuses.status_name as name from vicidial_campaign_statuses " .
                " WHERE vicidial_campaign_statuses.campaign_id = '" . $campa . "' ) ";

            $contador = 0;
            $datosxD = [];
            $estatus = [];

            $result = sv_mysqli_query($con, $query2);

            while ($row2 = sv_mysqli_fetch_array($result)) {

                if (!empty($row2["statusu"])) {

                    $estatus[$contador]["estatus"] = $row2["name"];
                    $query3 = "SELECT count(*) as cuantos, DATE_FORMAT(vicidial_log.call_date, '%Y-%m-%d %H:00:00') as fechaW,call_date from vicidial_log " .
                        "where vicidial_log.campaign_id = '" . $campa . "' and vicidial_log.status = '" . $row2["statusu"] . "' GROUP BY YEAR(vicidial_log.call_date), MONTH(vicidial_log.call_date), DAY(vicidial_log.call_date), HOUR(vicidial_log.call_date) ";
                    if ($archived) {
                        $query3 .= "SELECT count(*) as cuantos, DATE_FORMAT(vicidial_log_archive.call_date, '%Y-%m-%d %H:00:00') as fechaW,call_date from vicidial_log_archive " .
                            "where vicidial_log_archive.campaign_id = '" . $campa . "' and vicidial_log_archive.status = '" . $row2["statusu"] . "'" .
                            " GROUP BY YEAR(vicidial_log_archive.call_date), MONTH(vicidial_log_archive.call_date), DAY(vicidial_log_archive.call_date), HOUR(vicidial_log_archive.call_date) ";
                    }
                    $query3 .= "SELECT SUM(T.cuantos) AS cuantos,T.fechaW FROM ($query3) AS T GROUP BY YEAR(T.call_date), MONTH(T.call_date), DAY(T.call_date), HOUR(T.call_date) order by (T.call_date) ASC";

                    $result4 = sv_mysqli_query($con, $query3);

                    $contador2 = 0;

                    while ($row4 = sv_mysqli_fetch_array($result4)) {

                        $estatus[$contador]["calls"][$contador2]["cuenta"] = $row4["cuantos"];
                        $estatus[$contador]["calls"][$contador2]["fecha"] = $row4["fechaW"];

                        $contador2++;

                    }

                }

                $contador++;

            }

            $sal["estado"] = "ok";
            $sal["estatus"] = $estatus;
            $this->output->set_output(json_encode($sal));
            //$this->output->set_output(json_encode($campa));
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
}
