<?php
    /*
        CREATE TABLE IF NOT EXISTS dialvox_crm_lista(
            Lista VARCHAR(30) NOT NULL PRIMARY KEY,
            CRM INT NOT NULL
        );
    */
    require_once 'CRM/CRM.php';
    class Lista{
        private $id;
        private $nombre;
        private $campana;
        private $crm;
        private $activa;
        private $descripcion;
        private $fechaUltimaMarcacion;
        public function __construct(string $id, string $nombre, ?Campana $campana, ?CRM $crm, bool $activa, ?string $descripcion, ?string $fechaUltimaMarcacion){
            $this->id = $id;
            $this->nombre = $nombre;
            $this->campana = $campana;
            $this->crm = $crm;
        }
        public function getId():string{
            return $this->id;
        }
        public function setNombre(string $nombre):void{
            $this->nombre = $nombre;
        }
        public function getNombre():string{
            return $this->nombre;
        }
        public function setCampana(Campana $campana):void{
            $this->campana = $campana;
        }
        public function getCampana():Campana{
            return $this->campana;
        }
        public function getCRM():?CRM{
            return $this->crm;
        }
        public function setCRM(CRM $crm):void{
            $this->crm = $crm;
        }
        public function isActiva():bool{
            return $this->activa;
        }
        public function setActiva(bool $activa):void{
            $this->activa = $activa;
        }
        public function getDescripcion():string{
            return $this->descripcion;
        }
        public function setDescripcion(string $descripcion):void{
            $this->descripcion = $descripcion;
        }
        public function getFechaUltimaMarcacion():string{
            return $this->fechaUltimaMarcacion;
        }
        public function setFechaUltimaMarcacion(string $fechaUltimaMarcacion):void{
            $this->fechaUltimaMarcacion = $fechaUltimaMarcacion;
        }
        public function toJSON():array{
            $ret = array();
            $ret["id"] = $this->id;
            $ret["Nombre"] = $this->nombre;
            $ret["Campana"] = ($this->campana != null ?$this->campana->toJSON():null);
            $ret["CRM"] = ($this->crm == null?null:$this->crm->toJSON());
            $ret["Activa"] = $this->activa;
            $ret["Descripcion"] = $this->descripcion;
            $ret["FechaUltimaMarcacion"] = $this->fechaUltimaMarcacion;
            return $ret;
        }
    }
?>