<?php

/*

CREATE TABLE `dialvox_frame_agente` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `Campana` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT ' ',
    `Titulo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT ' ',
    `Url` varchar(150) COLLATE utf8_unicode_ci NOT NULL DEFAULT ' ',
    `Cliente` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT ' ',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

*/
class FrameAgente
{

    private $id;
    private $cliente;
    private $campana;
    private $url;
    private $titulo;
    private $estatico;

    public function __construct(
        $url = "", 
        $campana = "", 
        $titulo = "", 
        $cliente = NULL, 
        $id = "", 
        $estatico = false
    ) {
        $this->url = $url;
        $this->campana = $campana;
        $this->cliente = $cliente;
        $this->titulo = $titulo;
        $this->id = $id;
        $this->estatico = $estatico;
    }

    public function produceURL($data = array()) {
        $url_params = array();
        $url_values = array();
        foreach ($data as $param => $value) {
            array_push($url_params, "{{ $param }}");
            array_push($url_values, $value);
        }
        $postInt = strpos($this->url, "?");
        $urlBase = substr($this->url, 0, $postInt);
        $urlParams = substr($this->url, $postInt + 1);
        $urlParams = str_replace($url_params, $url_values, $urlParams);
        $this->url = $urlBase."?".$urlParams;
        return $this;
    }

    public function setCliente($cliente)
    {
        $this->cliente = $cliente;
        return $this;
    }

    public function setTitulo($titulo)
    {
        $this->titulo = $titulo;
        return $this;
    }

    public function setCampana($campana)
    {
        $this->campana = $campana;
        return $this;
    }

    public function setURL($url)
    {
        $this->url = $url;
        return $this;
    }

    public function setId($id) {
        $this->id = $id;
        return $this;
    }

    public function setEstatico($estatico) {
        $this->estatico = $estatico;
        return $this;
    }

    public function getEstatico() {
        return $this->estatico;
    }

    public function getId() {
        return $this->id;
    }

    public function getCliente()
    {
        return $this->cliente;
    }

    public function getTitulo()
    {
        return $this->titulo;
    }

    public function getCampana()
    {
        return $this->campana;
    }

    public function getURL()
    {
        return $this->url;
    }

    public function toJSON()
    {
        $r = array();
        if ($this->cliente !== NULL) {
            $r["Cliente"] = $this->cliente->toJSON();
        } else {
            $r["Cliente"] = NULL;
        }
        $r["id"] = $this->id;
        $r["Titulo"] = $this->titulo;
        $r["Campana"] = $this->campana;
        $r["Url"] = $this->url;
        $r["Estatico"] = $this->estatico;
        return $r;
    }
}
