<?php

require_once "Cliente.php";
require_once RUTA_APP . 'Conexion.php';

class OmnicanalidadConfig {

    private $id;
    private $cliente;
    private $label;
    private $url;
    private $userField;
    private $passwordField;
    private $userValue;
    private $passwordValue;
    private $loginURL;
    private $redirectURL;
    private $icon;

    function __construct(
        $id,
        $cliente,
        $label,
        $url,
        $userField,
        $passwordField,
        $userValue,
        $passwordValue,
        $loginURL,
        $redirectURL = "",
        $icon = ""
    )
    {
        $this->id = $id;
        $this->cliente = $cliente;
        $this->label = $label;
        $this->url = $url;
        $this->userField = $userField;
        $this->passwordField = $passwordField;
        $this->userValue = $userValue;
        $this->passwordValue = $passwordValue;
        $this->loginURL = $loginURL;
        $this->redirectURL = $redirectURL;
        $this->icon = $icon;
    }

    public static function getById($id) {
        $res = NULL;
        $con = getConnection();

        $result = sv_mysqli_query($con, "SELECT * FROM dialvox_cliente_omnicanalidad WHERE id=$id LIMIT 1");
        if ($row = sv_mysqli_fetch_array($result)) {
            $res = new OmnicanalidadConfig(
                $row["id"],
                $row["cliente"],
                $row["label"],
                $row["url"],
                $row["user_field"],
                $row["password_field"],
                $row["user_value"],
                $row["password_value"],
                $row["login_url"],
                $row["redirect_url"],
                $row["icon"]
            );
        }

        sv_mysqli_close($con);
        return $res;
    }

    public static function getAllByCliente($cliente, $toJson = FALSE, $assoc = FALSE) {

        $res = array();
        $con = getConnection();

        $id_cliente = $cliente;
        if ($cliente instanceof Cliente) {
            $id_cliente = $cliente->getId();
        }

        $result = sv_mysqli_query($con, "SELECT * FROM dialvox_cliente_omnicanalidad WHERE cliente='$id_cliente'");
        while ($row = sv_mysqli_fetch_array($result)) {
            $obj = new OmnicanalidadConfig(
                $row["id"],
                $row["cliente"],
                $row["label"],
                $row["url"],
                $row["user_field"],
                $row["password_field"],
                $row["user_value"],
                $row["password_value"],
                $row["login_url"],
                $row["redirect_url"],
                $row["icon"]
            );
            if ($assoc) {
                if ($toJson) {
                    $res[$row["label"]] = $obj->toJSON();
                } else {
                    $res[$row["label"]] = $obj;
                }
            } else {
                if ($toJson) {
                    array_push($res, $obj->toJSON());
                } else {
                    array_push($res, $obj);
                }
            }
        }

        sv_mysqli_close($con);
        return $res;
    }

    public static function insert(
        $cliente,
        $label,
        $url,
        $userField,
        $passwordField,
        $userValue,
        $passwordValue,
        $loginURL,
        $redirectURL,
        $icon
    ) {
        $res = NULL;
        $con = getConnection();

        $id_cliente = $cliente;
        if ($cliente instanceof Cliente) {
            $id_cliente = $cliente->getId();
        }

        $stmt = $con->prepare("INSERT INTO dialvox_cliente_omnicanalidad(cliente,label,url,user_field,password_field,user_value,password_value,login_url,redirect_url,icon) VALUES (?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param(
            "ssssssssss",
            $id_cliente,
            $label,
            $url,
            $userField,
            $passwordField,
            $userValue,
            $passwordValue,
            $loginURL,
            $redirectURL,
            $icon
        );

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    public static function update(
        $id,
        $label,
        $url,
        $userField,
        $passwordField,
        $userValue,
        $passwordValue,
        $loginURL,
        $redirectURL,
        $icon
    ) {
        $res = NULL;
        $con = getConnection();

        $stmt = $con->prepare("UPDATE dialvox_cliente_omnicanalidad SET label=?,url=?,user_field=?,password_field=?,user_value=?,password_value=?,login_url=?,redirect_url=?,icon=? WHERE id=?");
        $stmt->bind_param(
            "sssssssssi",
            $label,
            $url,
            $userField,
            $passwordField,
            $userValue,
            $passwordValue,
            $loginURL,
            $redirectURL,
            $icon,
            $id
        );

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    public static function delete($id) {
        $res = NULL;
        $con = getConnection();

        $stmt = $con->prepare("DELETE FROM dialvox_cliente_omnicanalidad WHERE id=?");
        $stmt->bind_param("i", $id);

        if (!$stmt->execute()) {
            $res = array(
                "ERROR" => $stmt->error,
                "ERRNO" => $stmt->errno
            );
        }

        $stmt->close();
        sv_mysqli_close($con);
        return $res;
    }

    function toJSON() {
        $json = array();

        if ($this->cliente instanceof Cliente) {
            $json["Cliente"] = $this->cliente->toJSON();
        } else {
            $json["Cliente"] = $this->cliente;
        }

        $json["Id"] = $this->id;
        $json["Label"] = $this->label;
        $json["URL"] = $this->url;
        $json["UserField"] = $this->userField;
        $json["PasswordField"] = $this->passwordField;
        $json["UserValue"] = $this->userValue;
        $json["PasswordValue"] = $this->passwordValue;
        $json["LoginURL"] = $this->loginURL;
        $json["RedirectURL"] = $this->redirectURL;
        $json["Icon"] = $this->icon;

        return $json;
    }

}

?>