<?php
    /*
      CREATE TABLE IF NOT EXISTS dialvox_crm_gestion(
        id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
        CRM INT NOT NULL,
        Lead INT NOT NULL,
        Fecha DATETIME NOT NULL,
        Telefono INT NOT NULL,
        Agente VARCHAR(50) NOT NULL,
        Calificacion VARCHAR(100) NOT NULL
      );
     */
    require_once 'CRMDatos.php';
    require_once RUTA_APP.'application/controllers/Clases/Usuario.php';
    class Gestion{
        private $id;
        private $crm;
        private $lead;
        private $fecha;
        private $telefono;
        private $agente;
        private $calificacion;
        public function __construct(?int $id, CRM $crm, int $lead, string $fecha, string $telefono, ?Usuario $agente, string $calificacion){
            $this->id = $id;
            $this->crm = $crm;
            $this->lead = $lead;
            $this->fecha = $fecha;
            $this->telefono = $telefono;
            $this->agente = $agente;
            $this->calificacion = $calificacion;
        }

        public function getId():?int{
            return $this->id;
        }
        public function setId(int $id):void{
            $this->id = $id;
        }


        public function getCRM():CRM{
            return $this->crm;
        }
        public function setCRM(CRM $crm):void{
            $this->crm = $crm;
        }



        public function getLead():int{
            return $this->lead;
        }
        public function setLead(int $lead):void{
            $this->lead = $lead;
        }


        public function getFecha():string{
            return $this->fecha;
        }
        public function setFecha(string $fecha):void{
            $this->fecha = $fecha;
        }



        public function setTelefono(string $telefono):void{
            $this->telefono = $telefono;
        }
        public function getTelefono():string{
            return $this->telefono;
        }


        public function setAgente(Usuario $agente):void{
            $this->agente = $agente;
        }
        public function getAgente():?Usuario{
            return $this->agente;
        }


        public function setCalificacion(string $calificacion):void{
            $this->agente = $calificacion;
        }
        public function getCalificacion():string{
            return $this->calificacion;
        }

        public function toJSON():array{
            $ret = array();
            $ret["id"] = $this->id;
            $ret["CRM"] = $this->crm->toJSON();
            $ret["Lead"] = $this->lead;
            $ret["Fecha"] = $this->fecha;
            $ret["Telefono"] = $this->telefono;
            $ret["Agente"] = ($this->agente!=null?$this->agente->toJSON():null);
            $ret["Calificacion"] = $this->calificacion;            
            return $ret;
        }
    }
