<div>
    <div class="row" v-if="!hsearch">
        <div class="col s4">
            <div class="input-field">
                <input type="text" @keyup="$emit('search', $event.target.value)" id="searchTableId">
                <label for="searchTableId">{{traducirFrase("Buscar")}}</label>
            </div>
        </div>
    </div>
    <table class="table striped highlight responsive-table" v-if="!loading">
        <thead>
            <th v-for="header in headers" :key="header.label">
                {{ header.label }}
            </th>
            <th v-if="options.length > 0" id="optsTableId">
                {{traducirFrase("Opciones")}}
            </th>
            <th v-if="disabled">
                {{ disabledText !== '' ? disabledText : traducirFrase("Activo") }}
            </th>
        </thead>
        <tbody>
            <tr v-if="data.length === 0">
                <td :colspan="headers.length + (options.length > 0 ? 1 : 0)">
                    <slot>{{ traducirFrase("No hay informacion que mostrar") }}</slot>
                </td>
            </tr>
            <tr v-for="d in data" :key="d[id]">
                <td v-for="value in headers" :key="value.key">
                    <a v-if="value.link" :href="d[value.key].link" >
                        {{ d[value.key].label }}
                    </a>
                    <span v-else>
                        {{ d[value.key] }}
                    </span>
                </td>
                <td v-if="options.length > 0">
                    <a
                        v-for="opt in options"
                        :key="opt.action"
                        href="#"
                        :class="opt.tooltip ? 'tooltipped' : ''"
                        :data-tooltip="opt.tooltip ? opt.tooltip : ''"
                        :data-position="opt.position ? opt.position : 'top'"
                        v-on:click="$emit(opt.action, d)"
                    >
                        <i class="material-icons">
                            {{ opt.icon }}
                        </i>
                    </a>
                </td>
                <td v-if="disabled">
                    <div class="switch">
                        <label class="active" v-if="d[disabled] == 'N'">
                            Off
                            <input type="checkbox" @click="$emit('disable', d)" :disabled="supervisor && supervisor == true">
                            <span class="lever "></span>
                            On
                        </label>
                        <label class="active" v-if="d[disabled] == 'Y'">
                            Off
                            <input type="checkbox" class="" checked @click="$emit('disable', d)" :disabled="supervisor && supervisor == true">
                            <span class="lever"></span>
                            On
                        </label>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    <div v-if="loading">
        <center><img src="<?=IMG_ADMIN;?>spinner.gif"></center>
    </div>
</div>