(function () {
	const app = new Vue({
		el: '#main',
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				headers: [
					{ label: traducirFrase('Nombre'), key: 'Nombre' },
					{ label: traducirFrase('Orden'), key: 'NextAgentCall' },
				],
				options: [
					{
						action: 'edit',
						tooltip: traducirFrase('Editar el grupo de entrada'),
						icon: 'edit',
					},
					{
						action: 'delete',
						tooltip: traducirFrase('Eliminar grupo de entrada'),
						icon: 'delete',
					},
					{
						action: 'download',
						tooltip: traducirFrase('Descargar reporte'),
						icon: 'cloud_download',
					},
					{
						action: 'campaign',
						tooltip: traducirFrase('Editar Campañas'),
						icon: 'playlist_add_check',
					},
					{
						action: 'users',
						tooltip: traducirFrase('Editar Usuarios'),
						icon: 'person_add',
					},
				],
				optionsConEncuesta: [
					{
						action: 'edit',
						tooltip: traducirFrase('Editar el grupo de entrada'),
						icon: 'edit',
					},
					{
						action: 'delete',
						tooltip: traducirFrase('Eliminar grupo de entrada'),
						icon: 'delete',
					},
					{
						action: 'download',
						tooltip: traducirFrase('Descargar reporte'),
						icon: 'cloud_download',
					},
					{
						action: 'campaign',
						tooltip: traducirFrase('Editar Campañas'),
						icon: 'playlist_add_check',
					},
					{
						action: 'polls', 
						tooltip: traducirFrase('Editar Encuestas'), 
						icon: 'poll'
					},
					{
						action: 'users',
						tooltip: traducirFrase('Editar Usuarios'),
						icon: 'person_add',
					},
				],
				// Variables para los modales
				targets: {
					add: false,
					edit: false,
					campaign: false,
					users: false,
					assoc: false,
				},
				// Registrar
				one: {
					id: '',
					nombre: '',
					nextAgentCall: '',
					activo: false,
					callTime: '24hours',
					id_poll: '',
				},
				//Campañas
				campanas: [],
				campanasHeaders: [{ label: traducirFrase('Campaña'), key: 'nombrecampana' }],
				idGrupoEntradaCampanas: '',
				campanasCargando: false,
				//Encuestas
				polls: [],
				id_ingroup: '',
				id_poll: '',
				associatedPolls: [],
				assocPoll: '',
				headerAssoc: [
					{label: traducirFrase("Nombre") , key: 'nombre'},
				],
				optionsAssoc: [
					{
						action: 'delete',
						tooltip: traducirFrase("Quitar Encuesta"),
						icon: 'delete',
					}
				],
				poll: '',
				// Editar
				// Paginacion
				pagina: 1,
				cuenta: 1,
				texto: '',
				callTimes: [],
				ingroup: '',
				// =====================================
				// Variables para los modales
				modalReporte: false,
				url: 'GrupoDeEntrada/getInboundReport?',
				// =====================================
				// INICIO =================================================
				// Relacion de usuarios - grupos de entrada
				usuarios: [],
				usuariosHeaders: [{ label: traducirFrase('Nombre'), key: 'nombre' }],
				idGrupoEntradaUsuarios: '',
				usuariosCargando: false,
				// FIN    =================================================
			};
		},
		methods: {
			download($evt) {
				this.url += 'campana=' + $evt.id;
				this.url += '&archived=1';
				this.url += '&csv=true';
				this.modalReporte = true;
				document.getElementById('datepickers-container').style.zIndex =
					'10000';
			},
			downloadReport() {
				let datesValues = $('#downloadDateIngroup').val().split(' - ');
				if (datesValues[0]) {
					this.url += '&fechaIni=' + datesValues[0];
				}
				if (datesValues[1]) {
					this.url += '&fechaFin=' + datesValues[1];
				}
				console.log(this.url);
				window.location.href = this.url;
				this.modalReporte = false;
				this.url = 'GrupoDeEntrada/getInboundReport?';
			},
			load() {
				let self = this;
				if (this.pagina > this.cuenta) {
					this.pagina = this.cuenta;
				}
				gen_rpost('GrupoDeEntrada/listarIngroups', {
					pagina: this.pagina - 1,
					texto: this.texto,
				})
					.then((results) => {
						self.registros = results.Ingroups;
						self.cuenta = Math.floor(+results.Cuenta / 15 + 1);
						if (results.Cuenta % 15 == 0) {
							self.cuenta--;
						}
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			sendData(url, toggle) {
				let self = this;
				handled_rpost(`GrupoDeEntrada/${url}`, {
					nombre: this.one.nombre,
					nextAgentCall: this.one.nextAgentCall,
					activo: this.one.activo ? 'Y' : 'N',
					callTime: this.one.callTime,
					id: this.one.id,
				})
					.then((res) => {
						if (self.pagina === 0) {
							window.location.reload();
						}
						self.toggle(toggle);
						self.load();
					})
					.catch((err) => console.log(err));
			},
			add(url, toggle) {
				this.sendData(url, toggle);
			},
			edit($evt) {
				let self = this;
				gen_rpost('GrupoDeEntrada/obtenerIngroup', {
					id: $evt.id,
				})
					.then((res) => {
						let {
							id,
							Activo,
							Nombre,
							NextAgentCall,
							CallTime,
						} = res.Ingroup;
						self.one = {
							activo: Activo == 'Y' ? true : false,
							nombre: Nombre,
							nextAgentCall: NextAgentCall,
							callTime: CallTime,
							id: id,
						};

						self.toggle('edit');
					})
					.catch((err) => console.log(err));
			},
			del($evt) {
				let self = this;
				conf_rpost(
					'GrupoDeEntrada/eliminarIngroup',
					{
						id: $evt.id,
					},
					traducirFrase('Continuar esta accion eliminara el grupo de entrada seleccionado')
				)
					.then((result) => {
						self.load();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			disable($evt) {
				gen_rpost('GrupoDeEntrada/desactivarIngroup', {
					id: $evt.id,
				})
					.then((result) => { })
					.catch((err) => {
						console.log(err);
					});
			},
			toggle(target) {
				this.obtenerCallTimes();
				if (target == 'add') {
					this.one = {
						nombre: '',
						nextAgentCall: '',
						activo: false,
						callTime: '24hours',
						id: '',
					};
				}
				app.targets[target] = !app.targets[target];
			},
			togglePoll(target, value){
				if (target == 'add') {
					this.one = {
						nombre: '',
						id_poll: '',
					};
				}
				app.targets[target] = value ? value : !app.targets[target];
			},
			obtenerCallTimes() {
				const self = this;
				selectCallTimes()
					.then((r) => {
						self.callTimes = r;
					})
			},
			abrirCampanas(ingroup) {
				this.idGrupoEntradaCampanas = ingroup.id;
				this.targets.campanas = true;
				this.cargarCampanas();
			},
			cerrarCampanas() {
				this.idGrupoEntradaCampanas = '';
				this.targets.campanas = false;
				this.campanas = [];
				this.campanasCargando = false;
			},
			cargarCampanas() {
				this.campanasCargando = "true";
				gen_rpost('Campanas/getCampaignsSelect', {})
					.then((rcampanas) => {
						gen_rpost('GrupoDeEntrada/seleccionarCampanasIngroup', {
							ingroup: this.idGrupoEntradaCampanas,
						})
							.then((rcampanasIngroups) => {
								this.campanas = rcampanas.Campanas.map(
									(campana) => ({
										idcampana: campana.campaign_id,
										nombrecampana: campana.campaign_name,
										activo: 'N',
									})
								);
								rcampanasIngroups.Campanas.map((uingroup) => {
									const campana = this.campanas.find(
										(v) => v.idcampana === uingroup
									);
									if (campana) {
										campana.activo = 'Y';
									}
								});
								this.campanasCargando = false;
							})
							.catch(console.log);
					})
					.catch(console.log)
			},
			toggleCampana(campana) {
				let url = 'GrupoDeEntrada/addCampaignToIngroup';
				if (campana.activo === 'Y') {
					url = 'GrupoDeEntrada/removeCampaignToIngroup';
				}
				const self = this
				handled_rpost(url, {
					ingroup: this.idGrupoEntradaCampanas,
					campana: campana.idcampana,
				})
					.then((r) => {
						campana.activo = campana.activo === 'Y' ? 'N' : 'Y';
						self.cargarCampanas();
					})
					.catch(console.log);
			},
			//Relación Encuestas - Grupos de Entrada
			abrirEncuestas(ingroup){
				let self = this;
				self.targets.editPolls = true;
			},
			assoc($evt){
				let self = this;
				gen_rpost('Encuestas/getEncuestasSelect' , {})
					.then((res) => {
						gen_rget('Encuestas/getEncuestasByInbound' , {
							group_id: $evt.id,
						})
							.then((resAssoc) => {
								self.id_ingroup = $evt.id;
								self.polls = res.Registros.map((v) => {
									return {
										value: v.id_encuesta,
										label: v.nombre,
									};
								});
							self.poll = "";
							self.associatedPolls = resAssoc.Registros;
							self.togglePoll('assoc' , true);
						})
						.catch((err) => console.log(err));
					})
					.catch((err) => console.log(err));
			},
			addAssoc(){
				let self = this;
				handled_rpost('Encuestas/assocInboundEncuesta', {
					group_id: this.id_ingroup,
					id_encuesta: this.poll,
				})
					.then((res) => {
						self.assocPoll = '';
						self.assoc({
							id: this.id_ingroup,
						});
					})
					.catch((err) => console.log(err));
			},
			deleteAssoc($event){
				let self = this;
				conf_rpost(
					'Encuestas/desassocInboundEncuesta',
					{
						group_id: self.id_ingroup,
						id_encuesta: $event.id_encuesta,
					},
					traducirFrase(
						'Continuar esta acción eliminara la encuesta al grupo de entrada seleccionado'
					)
				)
					.then((result) => {
						self.assoc({
							id: self.id_ingroup,
						})
					})
					.catch((err) => {
						console.log(err);
					})
			},
			// INICIO =================================================
			// Relacion de usuarios - grupos de entrada
			abrirUsuarios(ingroup) {
				this.idGrupoEntradaUsuarios = ingroup.id;
				this.targets.users = true;
				this.cargarUsuarios();
			},
			cerrarUsuarios() {
				this.idGrupoEntradaUsuarios = '';
				this.targets.users = false;
				this.usuarios = [];
				this.usuariosCargando = false;
			},
			cargarUsuarios() {
				this.usuariosCargando = true;
				this.usuarios = [];
				gen_rpost('Usuarios/getAgentSelect', {})
					.then((rusuarios) => {
						gen_rpost('GrupoDeEntrada/seleccionarUsuariosIngroup', {
							ingroup: this.idGrupoEntradaUsuarios,
						})
							.then((rusuariosIngroups) => {
								this.usuarios = rusuarios.usuarios.map(
									(usuario) => ({
										usuario: usuario.user,
										nombre: usuario.full_name,
										activo: 'N',
									})
								);
								rusuariosIngroups.Usuarios.map((uingroup) => {
									const usuario = this.usuarios.find(
										(v) => v.usuario === uingroup
									);
									if (usuario) {
										usuario.activo = 'Y';
									}
								});
								this.usuariosCargando = false;
							})
							.catch(console.log);
					})
					.catch(console.log);
			},
			toggleUsuario(usuario) {
				let url = 'GrupoDeEntrada/addUserToIngroup';
				if (usuario.activo === 'Y') {
					url = 'GrupoDeEntrada/removeUserToIngroup';
				}
				const self = this;
				handled_rpost(url, {
					campana: this.idGrupoEntradaUsuarios,
					usuario: usuario.usuario,
				})
					.then((r) => {
						usuario.activo = usuario.activo === 'Y' ? 'N' : 'Y';
						self.cargarUsuarios();
					})
					.catch(console.log);
			},
			activeAllUsuarios() {
				const promises = this.usuarios.map((usuario) => {
					if (usuario.activo === 'N') {
						rpost('GrupoDeEntrada/addUserToIngroup', {
							campana: this.idGrupoEntradaUsuarios,
							usuario: usuario.usuario,
						})
							.then((r) => {
								usuario.activo = 'Y';
							})
							.catch(console.log);
					}
				});

				Promise.all(promises).then((r) => {
					this.cargarUsuarios();
				});
			},
			disableAllUsuarios() {
				const promises = this.usuarios.map((usuario) => {
					if (usuario.activo === 'Y') {
						rpost('GrupoDeEntrada/removeUserToIngroup', {
							campana: this.idGrupoEntradaUsuarios,
							usuario: usuario.usuario,
						})
							.then((r) => {
								usuario.activo = 'N';
							})
							.catch(console.log);
					}
				});

				Promise.all(promises).then((r) => {
					this.cargarUsuarios();
				});
			}
			// FIN    =================================================
		},
		computed: {
			validForm() {
				return this.one.nombre != '' && this.one.nextAgentCall != '';
			},
			validPolls: function() {
				return this.polls.filter(v => !this.associatedPolls.find(p => v.value === p.id_encuesta))
			},
		},
		watch: {
			pagina() {
				this.load();
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			$('select').formSelect();
			let self = this;
			setInterval(self.load, 2000);
		},
	});

	app.load();
})();
