<div class="container animated fadeIn" v-if="targets.addRespuesta">
    <div class="row">
        <div class="dv-flex col">
            <button class="button btn-flat waves-effect waves-light" @click="targets.addRespuesta = false"><i class="material-icons">arrow_back</i></button>
            <h6 class="dv-flex-grow-1">
                {{traducirFrase("Agregar Respuesta")}}
            </h6>
        </div>
    </div>
    <div class="row dv-flex dv-centered noBottomMargin">
        <div class="input-field col dv-flex-grow-1">
            <input type="text" v-bind:placeholder="traducirFrase('Nombre')" class="nombreInput" v-model="respuesta.nombre" id="nombre">
            <label class="active" for="nombre">{{traducirFrase("Nombre")}}</label>
        </div>
        <div class="dv-flex-grow-1 input-field col">
            <input id="peso" type="number" v-bind:placeholder="traducirFrase('Peso')" v-model="respuesta.peso">   
            <label class="active" for="peso">{{traducirFrase("Peso")}}</label>
        </div>
    </div>
    <div class="row dv-flex dv-centered noBottomMargin">
        <div class="input-field col dv-flex-grow-1">
            <input id="indentificador" type="number" v-bind:placeholder="traducirFrase('Identificador de Respuesta')" v-model="respuesta.identificadorDeRespuesta" v-if="pregunta.tipoDeRespuestas == '1'">
            <label class="active" for="identificador"></label>
            <input id="identificador2" type="text" v-bind:placeholder="traducirFrase('Identificador de Respuesta')" v-model="respuesta.identificadorDeRespuesta" v-if="pregunta.tipoDeRespuestas == '2'">
            <label class="active" for="identificador2"></label>
        </div>
    </div>
    <div class="row dv-flex dv-centered noBottomMargin">
        <div class="input-field col dv-flex-grow-1">
            <select name="" id="selectorTipoAccion" class="browser-default" v-model="respuesta.tipoDeAccion">
                <option :value="1">{{traducirFrase("Colgar")}}</option>
                <option :value="2">{{traducirFrase("Transferir")}}</option>
                <option :value="3">{{traducirFrase("Pregunta")}}</option>
                <option :value="4">{{traducirFrase("Decisión")}}</option>
            </select>
            <label for="selectorTipoAccion" class="active">{{traducirFrase("Acción por defecto")}}</label>
        </div>
        <div class="dv-flex-grow-1 input-field col" v-if="respuesta.tipoDeAccion=='2'">
            <input type="text" id="telefonoInput" v-model="respuesta.valorDeAccion">
            <label for="telefonoInput" class="active">{{traducirFrase("Teléfono")}}</label>
        </div>
        <div class="dv-flex-grow-1 input-field col" v-if="respuesta.tipoDeAccion=='3'">
            <select name="" id="selectorValorPregunta" class="browser-default" v-model="respuesta.valorDeAccion">
                <option v-for="v in preguntas" :key="v.value" :value="v.value">
                        {{ v.label }}
                </option>
            </select>
            <label for="selectorValorPregunta" class="active">{{traducirFrase("Pregunta")}}</label>
        </div>
        <div class="dv-flex-grow-1 input-field col" v-if="respuesta.tipoDeAccion=='4'">
            <select name="" id="selectorValorDecision" class="browser-default" v-model="respuesta.valorDeAccion">
                <option v-for="v in decisiones" :key="v.value" :value="v.value">
                        {{ v.label }}
                </option>
            </select>
            <label for="selectorValorDecision" class="active">{{traducirFrase("Decisión")}}</label>
        </div>
    </div>
    <div class="row">
        <div class="col">
            <button class="btn waves-effect waves-light blue darken-1" @click="addRespuesta">
                {{traducirFrase("Agregar")}}
            </button>
        </div>
    </div>
</div>