<!DOCTYPE html>
<html translate="no" lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Manual del API de Agent Dialvox</title>
    <!-- Materialize Estilos -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/prismjs@1.20.0/themes/prism.css" />
</head>

<body>
    <nav>
        <div class="nav-wrapper blue-grey darken-4">
            <a href="#" class="brand-logo">Dialvox</a>
        </div>
    </nav>

    <div class="container">
        <div class="row">
            <h2>Manual de uso</h2>
            <h6 class="blue-grey-text text">API de Agente</h6>
        </div>
        <div class="row">
            <h5>Primeros pasos</h5>
            <p>
                Cómo se menciona en la documentación, en algun lugar de la
                página debe ser incluido un iframe para Dialvox, el cual
                puede estar oculto o no.
            </p>
        </div>
        <div class="row">
            <div class="col s12" id="dialvox-agente-campo">
                <br />
                <div class="row">
                    <div class="input-field col s12">
                        <input type="text" class="" id="dialvox-agente-usuario" value="AgenteAureolab" placeholder="Agente de dialvox" />
                        <label for="dialvox-agente-usuario">Agente</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col s12">
                <ul class="tabs">
                    <li class="tab col s3">
                        <a href="#dialvox-frame-ejemplo">Ejemplo</a>
                    </li>
                    <li class="tab col s3">
                        <a href="#dialvox-frame-html">
                            HTML
                        </a>
                    </li>
                </ul>
            </div>
            <div id="dialvox-frame-ejemplo" class="col s12">
                <div class="row">
                    <br />
                    <h6 class="blue-grey-text lighten-3 container">
                        El frame se encuentra oculto en este momento. En
                        algun momento sera necesario que se muestre
                        momentaneamente el frame para que el agente pueda
                        iniciar sesion.
                        <span class="red-text lighten-2">
                            Siempre se tiene que iniciar sesion desde el
                            iframe. Estos ejemplos funcionan especificamente
                            con el usuario AgenteAureolab.
                        </span>
                    </h6>
                </div>
                <div class="row">
                    <div class="col s12 center-align">
                        <button class="btn waves-effect waves-light red" id="dialvox-frame-button">
                            Mostrar iframe
                        </button>
                    </div>
                    <iframe id="dialvox-frame" class="col s8 offset-s2" style="
								height: 0px;
								visibility: hidden;
								transition: all 237ms ease-in-out;
							" src="https://cobranzas.corporativas.dialvox.com.mx/Dialvox/" frameborder="0" allow="microphone"></iframe>
                </div>
            </div>
            <div id="dialvox-frame-html" class="col s12">
                <pre class="language-html">
						<code class="language-html">
	&lt;iframe 
		src="https://cobranzas.corporativas.dialvox.com.mx/Dialvox/"
		width="0" height="0" 
	&gt;&lt;/iframe&gt;
						</code>
					</pre>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row" wait-login>
            <h5>Ejemplos</h5>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col s12">
                <h6>
                    Control del Agente
                </h6>
            </div>
            <div class="col s12">
                <ul class="tabs">
                    <li class="tab">
                        <a href="#dialvox-control-ejemplo">Ejemplo</a>
                    </li>
                    <li class="tab">
                        <a href="#dialvox-control-codigo">Código</a>
                    </li>
                </ul>
            </div>
            <div class="col s12" id="dialvox-control-ejemplo">
                <br />
                <div class="row">
                    <div class="col s12 center-align">
                        <button class="btn-floating btn-large waves-effect waves-light green" id="dialvox-control-play">
                            <i class="material-icons">play_arrow</i>
                        </button>
                        <button class="btn-floating btn-large waves-effect waves-light red" id="dialvox-control-hangup">
                            <i class="material-icons">call_end</i>
                        </button>
                    </div>
                </div>
                <p class="blue-grey-text text-darken-1">
                    Recordar que el agente siempre inicia pausado. Para
                    volver a poner pausa se tendria que obtener el listado
                    de estados de pausa para la campaña y enviar el codigo
                    con la pausa.
                </p>
            </div>
            <div class="col s12" id="dialvox-control-codigo">
                <pre>
						<code class="language-js"> 
	// Peticion para poner play
	const formData = new FormData()
    formData.append('accion', 'play')
    formData.append('usuario', inputAgente.value)
    axios
        .post(
            'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
            formData
        )
        .then(console.log)
        .catch(console.log);
	// Peticion para colgar
	const formData = new FormData()
    formData.append('accion', 'cuelga')
    formData.append('usuario', inputAgente.value)
    axios
        .post(
            'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
            formData
        )
        .then(console.log)
        .catch(console.log);
						</code>
					</pre>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col s12">
                <h6>Marcación manual</h6>
            </div>
            <div class="col s12">
                <ul class="tabs">
                    <li class="tab">
                        <a href="#dialvox-manual-ejemplo">Ejemplo</a>
                    </li>
                    <li class="tab">
                        <a href="#dialvox-manual-codigo">Codigo</a>
                    </li>
                </ul>
            </div>
            <div class="col s12" id="dialvox-manual-ejemplo">
                <br />
                <div class="row">
                    <div class="input-field col s12">
                        <input type="text" class="" id="dialvox-manual-telefono" data-length="10" maxlength="10" />
                        <label for="dialvox-manua-telefono">Telefono</label>
                    </div>
                </div>
                <div class="col s12 right-align">
                    <button id="dialvox-manual-marcar" class="btn red waves-effect waves-light">
                        Marcar
                    </button>
                </div>
            </div>
            <div class="col s12" id="dialvox-manual-codigo">
                <pre>
					<code class="language-js">
    const formData = new FormData()
    formData.append('accion', 'manualDial')
    formData.append('usuario', inputAgente.value)
    formData.append('numero', input.value)
    axios
        .post(
            'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
            formData
        )
        .then(console.log)
        .catch(console.log);
					</code>
				</pre>
            </div>
        </div>
    </div>
    <footer class="page-footer red">
        <div class="footer-copyright"></div>
    </footer>
    <!-- CDN's -->
    <!-- Axios es la libreria utilizada para realizar las peticiones -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/prismjs@1.20.0/prism.min.js"></script>
    <!-- Materialze Script -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
    <!-- Scripts -->
    <script>
        (function() {
            // Inicializacion de Materialize
            document.querySelectorAll('.tabs').forEach((tab) => {
                M.Tabs.init(tab, {});
            });
            document
                .querySelectorAll('.input-field>input[data-length]')
                .forEach((input) => {
                    new M.CharacterCounter(input);
                });

            // Funcion para hacer query mas facilmente
            const $ = (query) => {
                const obj = new Object({
                    el: document.querySelector(query),
                    click: function(listener) {
                        const self = this;
                        this.el.addEventListener('click', (evt) => {
                            listener.bind(self, evt)();
                        });
                    },
                });
                return obj;
            };

            const inputAgente = $("#dialvox-agente-usuario").el

            $('#dialvox-frame-button').click(function(evt) {
                const text = this.el.textContent.toLowerCase();
                const frame = $('#dialvox-frame').el;
                if (text === 'mostrar iframe') {
                    this.el.textContent = 'ocultar iframe';
                    frame.style.visibility = 'visible';
                    frame.style.height = '500px';
                } else {
                    this.el.textContent = 'mostrar iframe';
                    frame.style.visibility = 'hidden';
                    frame.style.height = '0px';
                }
            });
            $('#dialvox-manual-marcar').click(function(evt) {
                const input = $('#dialvox-manual-telefono').el;
                if (new RegExp('^[0-9]{10}$', 'g').test(input.value)) {
                    const formData = new FormData()
                    formData.append('accion', 'manualDial')
                    formData.append('usuario', inputAgente.value)
                    formData.append('numero', input.value)
                    axios
                        .post(
                            'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
                            formData
                        )
                        .then(console.log)
                        .catch(console.log);
                } else {
                    alert('El telefono no es valido');
                }
            });
            $('#dialvox-control-play').click(function() {
                const formData = new FormData()
                formData.append('accion', 'play')
                formData.append('usuario', inputAgente.value)
                axios
                    .post(
                        'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
                        formData
                    )
                    .then(console.log)
                    .catch(console.log);
            });
            $('#dialvox-control-hangup').click(function() {
                const formData = new FormData()
                formData.append('accion', 'cuelga')
                formData.append('usuario', inputAgente.value)
                axios
                    .post(
                        'https://cobranzas.corporativas.dialvox.com.mx/Dialvox/index.php/api/do1',
                        formData
                    )
                    .then(console.log)
                    .catch(console.log);
            });
        })();
    </script>
</body>

</html>