<?php
    /*
        CREATE TABLE IF NOT EXISTS dialvox_crm(
            id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
            Cliente VARCHAR(50) NOT NULL,            
            Nombre VARCHAR(50) NOT NULL,
            Color VARCHAR(15) NOT NULL,
            Visible BOOLEAN NOT NULL
        );
    */
    require_once RUTA_APP.'application/controllers/Clases/Cliente.php';
    require_once RUTA_APP.'application/controllers/Clases/Lista.php';
    class CRM{
        private $id;
        private $cliente;
        private $nombre;
        private $color;
        private $visible;
        private $ocultarInfo;
        public function __construct(?int $id, Cliente $cliente, string $nombre, string $color, bool $ocultarInfo, bool $visible){
            $this->id = $id;
            $this->cliente = $cliente;
            $this->nombre = $nombre;
            $this->color = $color;
            $this->ocultarInfo = $ocultarInfo;
            $this->visible = $visible;
        }        
        public function getId():int{
            return $this->id;
        }
        public function setId(int $id):void{
            $this->id = $id;
        }
        public function getCliente():Cliente{
            return $this->cliente;
        }
        public function setCliente(Cliente $cliente){
            $this->cliente = $cliente;
        }
        public function getNombre():string{
            return $this->nombre;
        }
        public function setNombre(string $nombre){
            $this->nombre = $nombre;
        }
        public function getColor():string{
            return $this->color;            
        }
        public function setColor(string $color):void{
            $this->color = $color;
        }
        public function isVisible():bool{
            return $this->visible;            
        }
        public function setVisible(bool $visible):void{
            $this->color = $visible;
        }
        public function getOcultarInfo():bool{
            return $this->ocultarInfo;            
        }
        public function setOcultarInfo(bool $ocultarInfo):void{
            $this->ocultarInfo = $ocultarInfo;
        }
        public function toJSON(){
            $ret = array();
            $ret["id"] = $this->getId();
            $ret["Cliente"] = $this->getCliente()->toJSON();
            $ret["Color"] = $this->getColor();
            $ret["Nombre"] = $this->getNombre();
            $ret["OcultarInfo"] = $this->getOcultarInfo();
            return $ret;
        }
    }
