(function () {
	var today = new Date();
	var dd = today.getDate();
	var mm = today.getMonth() + 1; //January is 0!
	var yyyy = today.getFullYear();
	if (dd < 10) {
		dd = '0' + dd;
	}
	if (mm < 10) {
		mm = '0' + mm;
	}
	var today = yyyy + '-' + mm + '-' + dd;
	console.log(today + ' - ' + today);
	$('#fechaReporteStatusAgente').val(today + ' - ' + today);

	const app = new Vue({
		el: '#main',
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				headers: [],
				filtro: '',
				tipo: 'outbound',
				campanasSelect: [],
				ingroupsSelect: [],
			};
		},
		methods: {
			load() {
				let self = this;
				let datesValues = $('#fechaReporteStatusAgente')
					.val()
					.split(' - ');
				$.get(`ReporteAgenteStatus/${this.tipo === 'outbound'
					? 'getAgenteReport'
					: 'getAgenteInboundReport'}`,
					{
						fechaInicio: datesValues[0],
						fechaFin: datesValues[1]
							? datesValues[1]
							: datesValues[0],
						campanas: [this.filtro],
						archived: document.getElementById(
							'checkboxArchiveStatusAgente'
						).checked
							? 1
							: 0,
					}
				)
					.then((results) => {
						console.log(results);
						const headers = [
							{
								label: traducirFrase('Usuario'),
								key: 'usuario',
							},
							{
								label: traducirFrase('Nombre'),
								key: 'nombreCompleto',
							},
						];
						results.status.forEach((status) => {
							if (status) {
								headers.push({
									label: status,
									key: status,
								});
							}
						});
						headers.push({
							label: 'Total',
							key: 'total',
						});
						this.headers = headers;
						const registros = [];
						const registroFinal = {
							usuario: 'Total',
							nombreCompleto: '',
						};
						let totalCompleto = 0;
						Object.keys(results.usuarios).forEach((key) => {
							const obj = results.usuarios[key].status;
							let total = 0;
							Object.keys(obj).forEach((objKey) => {
								obj[objKey] = obj[objKey] ? obj[objKey] : 0;
								total += parseInt(obj[objKey]);
							});
							obj['usuario'] = key;
							obj['nombreCompleto'] =
								results.usuarios[key].nombreCompleto;
							obj['total'] = total;
							results.status.forEach((status) => {
								if (!obj[status]) {
									obj[status] = 0;
								}
							});
							totalCompleto += total;
							registros.push(obj);
						});
						registroFinal['total'] = totalCompleto;
						registros.push(registroFinal);
						this.registros = registros;
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			descargar() {
				let self = this;
				let datesValues = $('#fechaReporteStatusAgente')
					.val()
					.split(' - ');
				let url = new URL(
					window.location.href +
					(this.tipo === 'outbound'
						? '/getAgenteReport'
						: '/getAgenteInboundReport')
				);
				url.searchParams.append('fechaInicio', datesValues[0]);
				url.searchParams.append(
					'fechaFin',
					datesValues[1] ? datesValues[1] : datesValues[0]
				);
				url.searchParams.append('campanas[]', [this.filtro]);
				url.searchParams.append('csv', true);
				if (document.getElementById('checkboxArchiveStatusAgente').checked)
					url.searchParams.append('archived', 1);

				window.location.assign(url.href);
			},
			obtenerCampanas() {
				const self = this;
				gen_rpost('Campanas/getCampaignsSelect', {})
					.then((r) => {
						self.campanasSelect = r.Campanas.map((campana) => {
							return {
								value: campana.campaign_id,
								label: campana.campaign_name,
							};
						});
					})
					.catch(console.log);
			},
			obtenerGruposEntrada() {
				const self = this;
				gen_rpost('GrupoDeEntrada/seleccionarIngroups', {})
					.then((r) => {
						self.ingroupsSelect = r.Ingroups.map((item) => {
							return {
								value: item.id,
								label: item.Nombre,
							};
						});
					})
					.catch(console.log);
			},
		},
		computed: {},
		watch: {},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			// $('select').formSelect()

			var today = new Date();
			var dd = today.getDate();
			var mm = today.getMonth() + 1; //January is 0!
			var yyyy = today.getFullYear();
			if (dd < 10) {
				dd = '0' + dd;
			}
			if (mm < 10) {
				mm = '0' + mm;
			}
			var today = yyyy + '-' + mm + '-' + dd;
			console.log(today + ' - ' + today);
			$('#fechaReporteStatusAgente').val(today + ' - ' + today);

			let self = this;
			this.obtenerCampanas();
			this.obtenerGruposEntrada();
			// setInterval(self.load, 2000)
		},
	});

	app.load();
	$('.tooltipped').tooltip();
})();
