<?php

require_once "BASEPATH.php";

class Categorias extends MY_Controller
{
    public function getCategoriesSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('categorias', "spanish");
                break;
            case "en":
                $this->lang->load('categorias', "english");
                break;
            default:
                $this->lang->load('categorias', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $con = getConnection();
            $sal = array();
            $sePuede = true;
            if ($sePuede) {
                $cliente = $_SESSION["Cliente"];
                $mas = "";
                if ($cliente == -1) {
                    $cliente = "";
                } else {
                    $mas = "+";
                }

                $where = "WHERE vsc_id REGEXP '^" . $cliente . "" . $mas . "[0-9]+$'";
                if ($_SESSION["Cliente"] == -1) {
                    $where = "";
                }

                $query = "SELECT vsc_name,vsc_id FROM vicidial_status_categories $where ORDER BY vsc_id";
                $result = sv_mysqli_query($con, $query);
                $sal["Registros"] = array();
                while ($row = sv_mysqli_fetch_array($result)) {
                    $sal["Registros"][] = $row;
                }
                $sal["Estado"] = "ok";
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getCategories()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('categorias', "spanish");
                break;
            case "en":
                $this->lang->load('categorias', "english");
                break;
            default:
                $this->lang->load('categorias', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $con = getConnection();
            $registros = 10;
            $pagina = $_POST["pagina"] - 1;
            $skip = $registros * $pagina;
            $sal = array();
            $sePuede = true;
            if ($sePuede) {
                $cliente = $_SESSION["Cliente"];
                $mas = "";
                if ($cliente == -1) {
                    $cliente = "";
                } else {
                    $mas = "+";
                }

                $where = "WHERE vsc_id REGEXP '^" . $cliente . "" . $mas . "[0-9]+$'";
                if ($_SESSION["Cliente"] == -1) {
                    $where = "";
                }

                $query = "SELECT vsc_name,vsc_id,vsc_description,tovdad_display,sale_category,dead_lead_category FROM vicidial_status_categories $where ORDER BY vsc_id DESC LIMIT $skip,$registros";
                $result = sv_mysqli_query($con, $query);
                $sal["Registros"] = array();
                while ($row = sv_mysqli_fetch_array($result)) {
                    $sal["Registros"][] = $row;
                }
                $query = "SELECT COUNT(vsc_id) FROM vicidial_status_categories WHERE vsc_id REGEXP '^" . $cliente . "" . $mas . "[0-9]+$'";
                $result = sv_mysqli_query($con, $query);
                $row = sv_mysqli_fetch_array($result);
                $sal["Cuenta"] = $row[0];
                $sal["Estado"] = "ok";
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addCategory()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('categorias', "spanish");
                break;
            case "en":
                $this->lang->load('categorias', "english");
                break;
            default:
                $this->lang->load('categorias', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $con = getConnection();
            //$campana = limpia($_POST["campana"]);
            $nombre = limpia($_POST["nombre"]);
            $descripcion = limpia($_POST["descripcion"]);
            $vdad = limpia($_POST["vdad"]);
            $sale = limpia($_POST["sale"]);
            $dead = limpia($_POST["dead"]);
            if ($dead == 'Y') {
                $dead = 'Y';
            } else {
                $dead = 'N';
            }

            if ($vdad == 'Y') {
                $vdad = 'Y';
            } else {
                $vdad = 'N';
            }

            if ($sale == 'Y') {
                $sale = 'Y';
            } else {
                $sale = 'N';
            }

            $cliente = "";
            $desc = "";
            $sal = array();
            $sePuede = true;
            if (strlen($nombre) < 2) {
                $sePuede = false;
                $desc = "desc_nombreCorto";
            }
            if ($sePuede) {
                $mas = "";
                if ($_SESSION["Cliente"] != -1) {
                    $cliente = $_SESSION["Cliente"];
                    $mas = "+";
                }
                $id = $cliente . "10";

                $query = "SELECT vsc_id FROM vicidial_status_categories WHERE vsc_id REGEXP '^" . $cliente . "" . $mas . "[0-9]+$' ORDER BY vsc_id DESC LIMIT 1";
                $result = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result)) {
                    $valorNumerico = (int) (str_replace($cliente, "", $row["vsc_id"]));
                    $valorNumerico += 1;
                    $id = $cliente . $valorNumerico;
                }
                $stmt = "INSERT INTO vicidial_status_categories (vsc_id,vsc_name,vsc_description,tovdad_display,sale_category,dead_lead_category) values('$id','$nombre','$descripcion','$vdad','$sale','$dead');";
                $rslt = sv_mysqli_query($con, $stmt);

                ### LOG INSERTION Admin Log Table ###
                $SQL_log = "$stmt|";
                $SQL_log = preg_replace('/;/', '', $SQL_log);
                $SQL_log = addslashes($SQL_log);
                $ip = $_SERVER["REMOTE_ADDR"];
                $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='STATUSCATEGORIES', event_type='ADD', record_id='$id', event_code='ADMIN ADD STATUS CATEGORY', event_sql=\"$SQL_log\", event_notes='';";
                $rslt = sv_mysqli_query($con, $stmt);
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line($desc);
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteCategory()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('categorias', "spanish");
                break;
            case "en":
                $this->lang->load('categorias', "english");
                break;
            default:
                $this->lang->load('categorias', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $con = getConnection();
            //$campana = limpia($_POST["campana"]);
            $categoria = limpia($_POST["categoria"]);
            $cliente = $_SESSION["Cliente"];
            $desc = "";
            $sal = array();
            $sePuede = true;
            if ($cliente != -1) {
                if (strpos($categoria, $cliente) === false) {
                    $sePuede = false;
                    $desc = $this->lang->line("desc_permisosEliminarCategoria");
                }
            }
            if ($sePuede) {
                $stmt = "DELETE FROM vicidial_status_categories WHERE vsc_id = '$categoria'";
                $rslt = sv_mysqli_query($con, $stmt);
                $SQL_log = "$stmt|";
                $SQL_log = preg_replace('/;/', '', $SQL_log);
                $SQL_log = addslashes($SQL_log);
                $ip = $_SERVER["REMOTE_ADDR"];
                $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='STATUSCATEGORIES', event_type='DELETE', record_id='$categoria', event_code='ADMIN ADD STATUS CATEGORY', event_sql=\"$SQL_log\", event_notes=''";
                $rslt = sv_mysqli_query($con, $stmt);
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line($desc);
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editCategory()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('categorias', "spanish");
                break;
            case "en":
                $this->lang->load('categorias', "english");
                break;
            default:
                $this->lang->load('categorias', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $con = getConnection();
            //$campana = limpia($_POST["campana"]);
            $nombre = limpia($_POST["nombre"]);
            $descripcion = limpia($_POST["descripcion"]);
            $vdad = limpia($_POST["vdad"]);
            $sale = limpia($_POST["sale"]);
            $dead = limpia($_POST["dead"]);
            $categoria = limpia($_POST["categoria"]);
            if ($dead == 'Y') {
                $dead = 'Y';
            } else {
                $dead = 'N';
            }

            if ($vdad == 'Y') {
                $vdad = 'Y';
            } else {
                $vdad = 'N';
            }

            if ($sale == 'Y') {
                $sale = 'Y';
            } else {
                $sale = 'N';
            }

            $cliente = $_SESSION["Cliente"];
            $desc = "";
            $sal = array();
            $sePuede = true;
            if ($cliente != -1) {
                if (strpos($categoria, $cliente) === false) {
                    $sePuede = false;
                    $desc = "desc_permisosEditarCategoria";
                }
            }
            if (strlen($nombre) < 2) {
                $sePuede = false;
                $desc = "desc_nombreCorto";
            }
            if ($sePuede) {
                $mas = "";
                if ($_SESSION["Cliente"] != -1) {
                    $cliente = $_SESSION["Cliente"];
                    $mas = "+";
                }
                $stmt = "UPDATE vicidial_status_categories SET vsc_name = '$nombre', vsc_description = '$descripcion',tovdad_display = '$vdad',sale_category='$sale',dead_lead_category='$dead' WHERE vsc_id = '$categoria'";
                $rslt = sv_mysqli_query($con, $stmt);

                ### LOG INSERTION Admin Log Table ###
                $SQL_log = "$stmt|";
                $SQL_log = preg_replace('/;/', '', $SQL_log);
                $SQL_log = addslashes($SQL_log);
                $ip = $_SERVER["REMOTE_ADDR"];
                $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='STATUSCATEGORIES', event_type='EDIT', record_id='$categoria', event_code='ADMIN ADD STATUS CATEGORY', event_sql=\"$SQL_log\", event_notes='';";
                $rslt = sv_mysqli_query($con, $stmt);
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line($desc);
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('categorias/head');
        $this->load->view('categorias/vw_categorias');
        $this->load->view('categorias/foot');
    }
}
