<?php

require_once "BASEPATH.php";

class AudioCliente extends MY_Controller
{

// Función para subir un audio
	public function uploadAudio() {
		include_once RUTA_APP . 'Conexion.php';
		if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS && $_SESSION["Cliente"] == -1) {
			header('Content-type: application/json');
			include_once RUTA_APP . 'Sesiones.php';
			$sal = [];
			$file = $_FILES["audio"];
			$idCliente = $_POST['idCliente'];
			$conn = getConnection();

			if ($file['error'] === UPLOAD_ERR_OK) {
				$fileTmpPath = $file['tmp_name'];
				$fileData = file_get_contents($fileTmpPath);
				$fileType = $file['type'];

				$stmt = $conn->prepare("INSERT INTO dialvox_audios_clientes (idCliente, audio, audio_tipo) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE audio = VALUES(audio), audio_tipo = VALUES(audio_tipo)");
                if (!$stmt) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = "Error en la consulta: " . $conn->error;
                    $this->output->set_output(json_encode($sal));
                    return;
                }

                $null = NULL;
                $stmt->bind_param("sbs", $idCliente, $null, $fileType);
                $stmt->send_long_data(1, $fileData);

				if ($stmt->execute()) {
					$sal["Estado"] = "ok";
					$sal["Descripcion"] = "Audio cargado correctamente.";
				} else {
					$sal["Estado"] = "error";
					$sal["Descripcion"] = "Error cargando el audio: " . $stmt->error;
				}
				$stmt->close();
			} else {
				$sal["Estado"] = "error";
				$sal["Descripcion"] = "Error al subir el archivo.";
			}

			$this->output->set_output(json_encode($sal));
		}
		else {
			$sal = array();
			$sal["Estado"] = "error";
			$sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
			$this->output->set_output(json_encode($sal));
		}
	}

	// Función para eliminar un audio
	public function deleteAudio() {
		include_once RUTA_APP . 'Conexion.php';
		if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS && $_SESSION["Cliente"] == -1) {
			header('Content-type: application/json');
			include_once RUTA_APP . 'Sesiones.php';
			$sal = [];
			$idCliente = $_POST['idCliente'];
			$conn = getConnection();

			$stmt = $conn->prepare("DELETE FROM dialvox_audios_clientes WHERE idCliente = ?");
			$stmt->bind_param("s", $idCliente);

			if ($stmt->execute()) {
				$sal["Estado"] = "ok";
				$sal["Descripcion"] = "Audio eliminado correctamente.";
			} else {
				$sal["Estado"] = "error";
				$sal["Descripcion"] = "Error al eliminar el audio: " . $stmt->error;
			}

			$this->output->set_output(json_encode($sal));
			
		}
		else {
			$sal = array();
			$sal["Estado"] = "error";
			$sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
			$this->output->set_output(json_encode($sal));
		}
	}

	// Función para obtener un audio
	public function getAudio() {
		include_once RUTA_APP . 'Conexion.php';
		$sal = [];
		$idCliente = $_GET['idCliente'];
		$conn = getConnection();

		$stmt = $conn->prepare("SELECT audio, audio_tipo FROM dialvox_audios_clientes WHERE idCliente = ?");
		$stmt->bind_param("s", $idCliente);

		if ($stmt->execute()) {
			$stmt->store_result();
			if ($stmt->num_rows > 0) {
				$stmt->bind_result($audio, $audio_tipo);
				$stmt->fetch();
				header("Content-Type: $audio_tipo");
				echo $audio; // Mostrar Audio
				return;
			} else {
				$sal["Estado"] = "error";
				$sal["Descripcion"] = "Audio no encontrado para el cliente especificado.";
			}
		} else {
			$sal["Estado"] = "error";
			$sal["Descripcion"] = "Error al obtener el audio: " . $stmt->error;
		}

		$this->output->set_output(json_encode($sal));
	}

	public function getAudioFromSession() {
		include_once RUTA_APP . 'Conexion.php';
		if (!empty($_SESSION["Usuario"])) {			
			include_once RUTA_APP . 'Sesiones.php';
			$sal = [];
			$idCliente = $_SESSION["Cliente"];
			$conn = getConnection();

			$stmt = $conn->prepare("SELECT audio, audio_tipo FROM dialvox_audios_clientes WHERE idCliente = ?");
			$stmt->bind_param("s", $idCliente);

			if ($stmt->execute()) {
				$stmt->store_result();
				if ($stmt->num_rows > 0) {
					$stmt->bind_result($audio, $audio_tipo);
					$stmt->fetch();
					header("Content-Type: $audio_tipo");
					echo $audio; // Mostrar audio
					return;
				} else {
					header('Content-type: application/json');
					$sal["Estado"] = "error";
					$sal["Descripcion"] = "Audio no encontrado para el cliente especificado.";
					$this->output->set_output(json_encode($sal));
				}
			} else {
				header('Content-type: application/json');
				$sal["Estado"] = "error";
				$sal["Descripcion"] = "Error al obtener el audio: " . $stmt->error;
				$this->output->set_output(json_encode($sal));
			}			
		}else {
			header('Content-type: application/json');
			$sal = array();
			$sal["Estado"] = "error";
			$sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
			$this->output->set_output(json_encode($sal));
		}
	}
}