<?php

require_once "BASEPATH.php";

require_once 'Clases/Latencia/LatenciaDatos.php';
require_once 'Clases/UsuarioDatos.php';
require_once 'Clases/ClienteDatos.php';
include_once RUTA_APP . 'Conexion.php';

class Latencia extends MY_Controller
{
    private function cargarIdioma()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('latencias', "spanish");
                break;
            case "en":
                $this->lang->load('latencias', "english");
                break;
            default:
                $this->lang->load('latencias', "spanish");
                break;
        }
    }
    public function obtenerLatencia()
    {
        header('Content-type: application/json');
        $this->cargarIdioma();
        $sal = array();

        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = UsuarioDatos::getUsuarioByUsuario($_SESSION["Usuario"]);
            $con = getConnection();
            $latencia = Latencia\LatenciaDatos::getLatenciaByUsuario($usuario, $con);
            if ($latencia == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("obtenerLatencia_latenciaNoEncontrada");
            } else {
                $sal["Estado"] = "ok";
                $sal["Datos"] = array(
                    "id" => $latencia->getId(),
                    "latencias" => array(
                        "dialvox" => $latencia->getLatenciaDialvox(),
                        "vicidial" => $latencia->getLatenciaVicidial(),
                        "telefonia" => $latencia->getLatenciaTelefonia(),
                    ),
                );
            }
            mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("obtenerLatencia_errorPermisos");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function obtenerTodasLasLatencias()
    {
        header('Content-type: application/json');
        $this->cargarIdioma();
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $con = getConnection();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $latencias = array();
            $sal["Estado"] = "ok";
            $sal["Datos"] = array();
            if ($cliente->getId() == "-1") {
                $latencias = Latencia\LatenciaDatos::getAllLatencias($con);
            } else {
                $latencias = Latencia\LatenciaDatos::getAllLatenciasByCliente($cliente, $con);
            }
            for ($i = 0; $i < count($latencias); $i++) {
                $sal["Datos"][] = array(
                    "id" => $latencias[$i]->getId(),
                    "Usuario" => $latencias[$i]->getUsuario()->toJSON(),
                    "Latencias" => array(
                        "dialvox" => $latencias[$i]->getLatenciaDialvox(),
                        "vicidial" => $latencias[$i]->getLatenciaVicidial(),
                        "telefonia" => $latencias[$i]->getLatenciaTelefonia(),
                    ),
                );
            }
            mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("obtenerTodasLasLatencias_errorPermisos");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function actualizarLatenciaDialvox()
    {
        header('Content-type: application/json');
        $this->cargarIdioma();
        $sal = array();

        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = UsuarioDatos::getUsuarioByUsuario($_SESSION["Usuario"]);
            $con = getConnection();
            $latencia = Latencia\LatenciaDatos::getLatenciaByUsuario($usuario, $con);
            $sal["Estado"] = "ok";
            $latenciaINT = intval($_POST["timestamp"]);
            $ip = $_SERVER['REMOTE_ADDR'];
            if ($latencia == null) {
                $latencia = new Latencia\Latencia(
                    null,
                    $usuario,
                    $latenciaINT,
                    -1,
                    -1,
                    new DateTime(),
                    new DateTime(),
                    new DateTime(),
                    "0.0.0.0",
                    $ip
                );
                Latencia\LatenciaDatos::insertLatencia($latencia, $con);
            } else {
                $latencia->setIpWeb($ip);
                $latencia->setLatenciaDialvox($latenciaINT);
                $latencia->setFechaDialvox(new DateTime());
                $sal["query"] = Latencia\LatenciaDatos::updateLatencia($latencia, $con);
            }
            $sal["latencia_dialvox"] = $latenciaINT;
            mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("actualizarLatenciaDialvox_errorPermisos");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function actualizarLatenciaVicidial()
    {
        header('Content-type: application/json');
        $this->cargarIdioma();
        $sal = array();

        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = UsuarioDatos::getUsuarioByUsuario($_SESSION["Usuario"]);
            $con = getConnection();
            $latencia = Latencia\LatenciaDatos::getLatenciaByUsuario($usuario, $con);
            $sal["Estado"] = "ok";
            $latenciaINT = int($_POST["latencia"]);
            if ($latencia == null) {
                $latencia = new Latencia\Latencia(
                    null,
                    $usuario,
                    -1,
                    $latenciaINT,
                    -1,
                    new DateTime(),
                    new DateTime(),
                    new DateTime(),
                    "0.0.0.0",
                    $ip
                );
                Latencia\LatenciaDatos::insertLatencia($latencia, $con);
            } else {
                $latencia->setIpWeb($ip);
                $latencia->setLatenciaVicidial($latenciaINT);
                $latencia->setFechaVicidial(new DateTime());
                Latencia\LatenciaDatos::updateLatencia($latencia);
            }
            mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("actualizarLatenciaVicidial_errorPermisos");
        }
        $this->output->set_output(json_encode($sal));
    }
}
