<?php
require_once 'Extension.php';
require_once 'ClienteDatos.php';
require_once RUTA_APP . 'Conexion.php';
class ExtensionDatos
{
    public static function getExtensionByExtension($extension)
    {
        $con = getConnection();
        $query = "SELECT extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt FROM phones WHERE extension = '" . $extension . "'";
        $result = sv_mysqli_query($con, $query);
        $resp = null;
        if ($row = sv_mysqli_fetch_array($result)) {
            $resp = new Extension(
                $row["extension"],
                $row["dialplan_number"],
                $row["voicemail_id"],
                $row["outbound_cid"],
                ClienteDatos::getClienteById($row["user_group"]),
                $row["server_ip"],
                $row["login"],
                $row["pass"],
                $row["status"],
                $row["active"],
                $row["fullname"],
                $row["protocol"],
                $row["local_gmt"],
                $row["phone_type"]
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getExtensionesByCliente($cliente, $texto, $pagina, $limite)
    {
        $con = getConnection();
        $query = "SELECT extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt FROM phones WHERE user_group = '" . limpia($cliente->getId()) . "' AND  extension LIKE '%" . limpia($texto) . "%' LIMIT " . ($pagina * $limite) . "," . $limite;
        $result = sv_mysqli_query($con, $query);
        $resp = array();
        while ($row = sv_mysqli_fetch_array($result)) {
            $resp[] = new Extension(
                $row["extension"],
                $row["dialplan_number"],
                $row["voicemail_id"],
                $row["outbound_cid"],
                $cliente,
                null,
                $row["login"],
                $row["pass"],
                null,
                $row["active"],
                $row["fullname"],
                $row["protocol"],
                null,
                $row["phone_type"]
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countExtensionesByCliente($cliente, $texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(extension) AS CUENTA FROM phones WHERE user_group = '" . limpia($cliente->getId()) . "' AND extension LIKE '%" . limpia($texto) . "%'";
        $resp = 0;
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
            }
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllExtensionesByCliente($cliente)
    {
        $con = getConnection();
        $query = "SELECT extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt FROM phones WHERE user_group = '" . limpia($cliente->getId()) . "'";
        $result = sv_mysqli_query($con, $query);
        $resp = array();
        while ($row = sv_mysqli_fetch_array($result)) {
            $resp[] = new Extension(
                $row["extension"],
                null,
                null,
                null,
                $cliente,
                null,
                null,
                null,
                null,
                $row["active"],
                $row["fullname"],
                $row["protocol"],
                null,
                null
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getExtensiones($texto, $pagina, $limite)
    {
        $con = getConnection();
        $query = "SELECT extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt FROM phones WHERE extension LIKE '%" . limpia($texto) . "%' LIMIT " . ($pagina * $limite) . "," . $limite;
        $result = sv_mysqli_query($con, $query);
        $resp = array();
        while ($row = sv_mysqli_fetch_array($result)) {
            $resp[] = new Extension(
                $row["extension"],
                $row["dialplan_number"],
                $row["voicemail_id"],
                $row["outbound_cid"],
                ClienteDatos::getClienteById($row["user_group"]),
                null,
                $row["login"],
                $row["pass"],
                null,
                $row["active"],
                $row["fullname"],
                $row["protocol"],
                null,
                $row["phone_type"]
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countExtensiones($texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(extension) AS CUENTA FROM phones WHERE extension LIKE '%" . limpia($texto) . "%'";
        $resp = 0;
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
            }
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllExtensiones()
    {
        $con = getConnection();
        $query = "SELECT extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt FROM phones";
        $result = sv_mysqli_query($con, $query);
        $resp = array();
        while ($row = sv_mysqli_fetch_array($result)) {
            $resp[] = new Extension(
                $row["extension"],
                null,
                null,
                null,
                ClienteDatos::getClienteById($row["user_group"]),
                null,
                null,
                null,
                null,
                $row["active"],
                $row["fullname"],
                $row["protocol"],
                null,
                null
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function addExtension($extension)
    {
        $con = getConnection();
        $query = "INSERT INTO phones (extension,dialplan_number,voicemail_id, outbound_cid, user_group, server_ip,login,pass,status,active, phone_type, fullname, protocol , local_gmt) VALUES (
				'" . limpia($extension->getExtension()) . "',
				'" . limpia($extension->getNumeroPlanDeMarcacion()) . "',
				'" . limpia($extension->getVoicemail()) . "',
				'" . limpia($extension->getIdentificadorSaliente()) . "',
				'" . limpia($extension->getCliente()->getId()) . "',
				'" . limpia($extension->getServidor()) . "',
				'" . limpia($extension->getUsuario()) . "',
				'" . limpia($extension->getPassword()) . "',
				'" . limpia($extension->getStatus()) . "',
				'" . limpia($extension->getActiva()) . "',
				'" . limpia($extension->getTipoTelefono()) . "',
				'" . limpia($extension->getNombre()) . "',
				'" . limpia($extension->getProtocolo()) . "',
				'" . limpia($extension->getLocalGMT()) . "'
			)";
        $resp = -1;
        if ($result = sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function updateExtension($extension)
    {
        $con = getConnection();
        $query = "UPDATE phones SET
					dialplan_number = '" . limpia($extension->getNumeroPlanDeMarcacion()) . "',
					voicemail_id = '" . limpia($extension->getVoicemail()) . "',
					outbound_cid = '" . limpia($extension->getIdentificadorSaliente()) . "',
					user_group = '" . limpia($extension->getCliente()->getId()) . "',
					login = '" . limpia($extension->getUsuario()) . "',
					pass = '" . limpia($extension->getPassword()) . "',
					active = '" . limpia($extension->getActiva()) . "',
					phone_type = '" . limpia($extension->getTipoTelefono()) . "',
					fullname = '" . limpia($extension->getNombre()) . "',
					protocol = '" . limpia($extension->getProtocolo()) . "'
				WHERE
					extension = '" . limpia($extension->getExtension()) . "'
				LIMIT 1
			";
        $resp = -1;
        if ($result = sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function deleteExtension($extension)
    {
        $con = getConnection();
        $query = "DELETE FROM phones WHERE extension = '" . limpia($extension->getExtension()) . "' LIMIT 1";
        $resp = -1;
        if ($result = sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        }
        sv_mysqli_close($con);
        return $resp;
    }
}
