<?php
    namespace Encuesta;
    require_once 'Respuesta.php';
    require_once 'PreguntaDatos.php';
    class RespuestaDatos{
        public static function getRespuestaById(int $id, $conexion):?Respuesta{
            $respuesta = null;
            if($stmt = $conexion->prepare("SELECT id_respuesta,id_pregunta, nombre, identificadorDeRespuesta, peso, tipoDeAccion, valorDeAccion FROM dialvox_respuesta WHERE id_respuesta = ? LIMIT 1")){
                $stmt->bind_param("i", $id);
                $stmt->execute();
                $stmt->bind_result($id_respuesta, $id_pregunta, $nombre, $identificadorDeRespuesta, $peso, $tipoDeAccion, $valorDeAccion);                
                $sePuede = false;
                if($stmt->fetch()){                                        
                    $sePuede = true;                    
                }
                $stmt->close();
                if($sePuede)                
                    $respuesta = new Respuesta($id_respuesta, PreguntaDatos::getPreguntaById($id_pregunta, $conexion), $nombre, $identificadorDeRespuesta, $peso, $tipoDeAccion, $valorDeAccion);
            }else{
                echo("3".$conexion->error);
            }
            return $respuesta;  
        }
        public static function getRespuestasByPregunta(Pregunta $pregunta, $conexion):array{
            $respuesta = array();
            if($stmt = $conexion->prepare("SELECT id_respuesta,id_pregunta,nombre,identificadorDeRespuesta,peso,tipoDeAccion,valorDeAccion FROM dialvox_respuesta WHERE id_pregunta = ?")){
                $id = $pregunta->getId();
                $stmt->bind_param("i", $id);
                $stmt->execute();
                $stmt->bind_result($id_respuesta, $id_pregunta, $nombre, $identificadorDeRespuesta, $peso, $tipoDeAccion, $valorDeAccion);
                while ($stmt->fetch()) {
                    $respuesta[] = new Respuesta($id_respuesta, $pregunta, $nombre, $identificadorDeRespuesta, $peso, $tipoDeAccion, $valorDeAccion);
                }
                $stmt->close();                         
            }else{
                echo("3".$conexion->error);
            }
            return $respuesta;  
        }
        
    }        
?>
