<?php
    /*
     CREATE TABLE IF NOT EXISTS dialvox_crm_campo(
        id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
        Categoria INT NOT NULL,
        Tipo INT NOT NULL,
        Edicion INT NOT NULL,
        Nombre VARCHAR(50) NOT NULL,
        Valor LONGTEXT NOT NULL,
        Busqueda BOOLEAN NOT NULL DEFAULT TRUE,
        Visible BOOLEAN NOT NULL DEFAULT TRUE,
        Requerido BOOLEAN NOT NULL DEFAULT FALSE,
      );
     */
    require_once 'CRM.php';
    require_once 'Categoria.php';
    class Campo{        
        private $id; //El id en la base de datos        
        private $categoria; //La categoria a la que pertenece
        private $tipo; 
        /*
            1:  textarea
            2:  text
            3:  select
            4:  checkbox
        */
        private $edicion;
        /*
            0:  no visible
            1:  no editable
            2:  editable
            3:  solo escribible por el agente
        */
        private $nombre;
        private $valor;        
        private $busqueda;
        private $visible; // Si el campo esta eliminado o no
        private $requerido;
        public function __construct(?int $id, Categoria $categoria, int $tipo, int $edicion, string $nombre, string $valor, bool $busqueda, bool $visible, bool $requerido){
            $this->id = $id;      
            $this->categoria = $categoria;             
            $this->tipo = $tipo;
            $this->edicion = $edicion;
            $this->nombre = $nombre;
            $this->valor = $valor;                 
            $this->busqueda = $busqueda;            
            $this->visible = $visible;
            $this->requerido = $requerido;
        }
        public function getId():?int{
            return $this->id;
        }
        public function setId(int $id):void{
            $this->id = $id;
        }
        public function getTipo():int{
            return $this->tipo;
        }
        public function setTipo(int $tipo):void{
            $this->tipo = $tipo;
        }
        public function getEdicion():int{
            return $this->edicion;
        }
        public function setEdicion(int $edicion):void{
            $this->edicion = $edicion;
        }
        public function getNombre():string{
            return $this->nombre;
        }
        public function setNombre(string $nombre):void{
            $this->nombre = $nombre;
        }
        public function getValor():string{
            return $this->valor;
        }
        public function setValor(string $valor):void{
            $this->valor = $valor;
        }
        public function getBusqueda():bool{
            return $this->busqueda;
        }        
        public function setBusqueda(bool $busqueda):void{
            $this->busqueda = $busqueda;
        }
        public function getCategoria():Categoria{
            return $this->categoria;
        }        
        public function setCategoria(Categoria $categoria):void{
            $this->categoria = $categoria;
        }
        public function isVisible():bool{
            return $this->visible;
        }        
        public function setVisible(bool $visible):void{
            $this->visible = $visible;
        }
        public function getRequerido():bool{
            return $this->requerido;
        }
        public function setRequerido(bool $requerido):void{
            $this->requerido = $requerido;
        }
        public function toJSON():array{
            $ret = array();
            $ret["id"] = $this->id;
            $ret["Categoria"] = $this->categoria->toJSON();
            $ret["Tipo"] = $this->tipo;
            $ret["Edicion"] = $this->edicion;
            $ret["Nombre"] = $this->nombre;
            $ret["Valor"] = $this->valor;
            $ret["Busqueda"] = $this->busqueda;
            $ret["Requerido"]=$this->requerido;
            return $ret;
        }
    }
?>