(function () {
	const defaultOptions = [{ value: '-1', label: traducirFrase('Selecciona una campaña') }];

	const labels = {
		Totales: traducirFrase('Total de llamadas'),
		TotalSistema: traducirFrase('Llamadas del sistema'),
		TotalAgentCalls: traducirFrase('Llamadas del agente'),
	};

	const labelsGeneral = {
		Totales: traducirFrase('Total de llamadas'),
		TotalSistema: traducirFrase('Llamadas del sistema'),
		TotalAgentCalls: traducirFrase('Llamada del agente'),
		DropPorcentaje: traducirFrase('% Abandono'),
		NoContestadasPorcentaje: traducirFrase('% No contestadas'),
		TotalTiempo: traducirFrase('Tiempo total'),
		TotalTiempoPause: traducirFrase('Tiempo en pausa'),
		LlamadaDNC: traducirFrase('No volver a llamar'),
		LlamadasVenta: traducirFrase('Ventas'),
	};

	const options = {
		colors: ['#009688', '#0097a7', '#0277bd'],
		series: [
			{
				name: traducirFrase('Total de llamadas'),
				data: new Array(24).fill(0),
			},
			{
				name: traducirFrase('Llamadas del sistema'),
				data: new Array(24).fill(0),
			},
			{
				name: traducirFrase('Llamada del agente'),
				data: new Array(24).fill(0),
			},
		],
		chart: {
			type: 'bar',
			height: 250,
			width: '100%',
		},
		plotOptions: {
			bar: {
				horizontal: false,
				endingShape: 'rounded',
			},
		},
		dataLabels: {
			enabled: false,
		},
		stroke: {
			show: true,
			width: 2,
			colors: ['transparent'],
		},
		xaxis: {
			categories: new Array(24).fill(0).map((v, i) => `${i}hrs`),
		},
		yaxis: {
			title: {
				text: traducirFrase('Llamadas'),
			},
		},
		fill: {
			opacity: 1,
		},
		tooltip: {
			y: {
				formatter: function (val) {
					return val;
				},
			},
		},
	};

	const app = new Vue({
		el: '#main',
		data() {
			return {
				campana: '-1',
				options: defaultOptions,
				grafica: null,
				archived: false,
				headers: [
					{ label: traducirFrase('Hora'), key: 'hora' },
					...Object.keys(labelsGeneral).map((v) => ({
						label: labelsGeneral[v],
						key: v,
					})),
				],
				desglose: new Array(24).fill(0).map((v, i) => ({
					hora: i,
					DropPorcentaje: 0,
					LlamadaDNC: 0,
					LlamadasVenta: 0,
					NoContestadasPorcentaje: 0,
					TotalAgentCalls: 0,
					TotalSistema: 0,
					TotalTiempo: '00:00:00',
					TotalTiempoPause: '00:00:00',
					Totales: 0,
				})),
				general: {
					DropPorcentaje: 0,
					LlamadaDNC: 0,
					LlamadasVenta: 0,
					NoContestadasPorcentaje: 0,
					TotalAgentCalls: 0,
					TotalSistema: 0,
					TotalTiempo: '00:00:00',
					TotalTiempoPause: '00:00:00',
					Totales: 0,
				},
			};
		},
		methods: {
			getFecha() {
				return $('#fechaReporte').val().split(' - ');
			},
			load() {
				const [fechaInicio, fechaFin] = this.getFecha();
				document.getElementById('spinner').style.display = 'block';
				rget('ReporteSalientesHora/summaryHourly', {
					fechaInicio: fechaInicio,
					fechaFin: fechaFin ? fechaFin : fechaInicio,
					archived: this.archived ? 1 : 0,
					campana: this.campana,
				})
					.then((r) => {
						gen_rpost('Campanas/getCampaignsSelect', {})
							.then((rcamp) => {
								this.options = [
									...defaultOptions,
									...rcamp.Campanas.map((v) => ({
										value: v.campaign_id,
										label: v.campaign_name,
									})),
								];
								this.desglose = r.Desglose.map((v, i) => ({
									hora: i,
									...v,
								}));
								this.general = r.General;
								this.grafica.updateSeries(
									Object.keys(labels).map((l) => {
										return {
											name: labels[l],
											data: r.Desglose.map((d) => d[l]),
										};
									})
								);
								document.getElementById(
									'spinner'
								).style.display = 'none';
							})
							.catch(console.log);
					})
					.catch(console.log);
			},
			descargar() {
				const [fechaInicio, fechaFin] = this.getFecha();
				window.location.href = `${DV_MODULOS}/ReporteSalientesHora/summaryHourly?fechaInicio=${fechaInicio}&fechaFin=${fechaFin ? fechaFin : fechaInicio
					}&archived=${this.archived ? 1 : 0}&campana=${this.campana
					}&csv=1`;
			},
		},
		computed: {
			tarjetasGeneral() {
				return Object.keys(this.general)
					.filter(
						(v) =>
							![
								'Totales',
								'TotalSistema',
								'TotalAgentCalls',
							].includes(v)
					)
					.map((v) => ({
						label: labelsGeneral[v],
						value: v,
					}));
			},
			tablaLabels() {
				return Object.keys(labelsGeneral).map((v) => ({
					label: labelsGeneral[v],
					value: v,
				}));
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			$('#fechaReporte').val(new Date().toISOString().split('T').shift());
			this.grafica = new ApexCharts(this.$refs.grafica, options);
			this.grafica.render();
			this.load();
		},
	});
})();
