<?php

require_once "BASEPATH.php";
require_once 'Clases/UsuarioDatos.php';
require_once 'Clases/Usuario.php';
require_once 'Clases/Cliente.php';

class Monitoreo extends MY_Controller{
    private function procesa_cliente($cliente){
        $pos = strpos($cliente, "_");
        return substr($cliente, 0, $pos);
    }
    public function getLatencias(){        
        include_once RUTA_APP . 'Conexion.php';
        $salida = array();
        if(!isset($_POST["usuario"]) or !isset($_POST["password"])){
            $salida["Estado"] = "error";
            $salida["Descripcion"] = "Usuario o contraseña no enviada";            
        }else{            
            $usuario = $_POST["usuario"];
            $password = $_POST["password"];
            if(empty($usuario) || empty($password)){
                $salida["Estado"] = "error";
                $salida["Descripcion"] = "Usuario o contraseña no enviada"; 
            }else{
                $usuarioEnSistema = UsuarioDatos::getUsuarioByUsuarioAndPassword($usuario, $password);
                if($usuarioEnSistema == null){
                    $salida["Estado"] = "error";
                    $salida["Descripcion"] = "Usuario o contraseña incorrectos"; 
                }else{                    
                    $cliente = $usuarioEnSistema->getCliente();
                    $esRoot = false;                       
                    if ($cliente->esRoot() || strcmp($cliente->getId(), "ADMIN") === 0)
                        $esRoot = true;
                    if(str_contains($cliente->getId(), "_ADMIN") || $esRoot){
                        $con = getConnection();
                        $agregadoQuery = "";                                        
                        if(!$esRoot){
                            $agregadoQuery = "usuario IN (SELECT user from vicidial_users where user_group = '".$cliente->getId()."_AGENTES') AND ";
                        }
                        $query = "SELECT usuario, (SELECT campaign_name from vicidial_campaigns where campaign_id in (select campaign_id from vicidial_live_agents WHERE user = dialvox_latencias.usuario)) as campania, (select user_group from vicidial_users WHERE user = dialvox_latencias.usuario) as cliente, latencia_telefonia, latencia_dialvox, ip_telefonia, ip_web FROM dialvox_latencias WHERE ".$agregadoQuery." TIME_TO_SEC(TIMEDIFF(NOW(), fecha_telefonia)) < 60";                        
                        $result = sv_mysqli_query($con, $query);
                        $salida["Latencias"] = array();
                        $salida["Clientes"] = array();                        
                        while ($row = sv_mysqli_fetch_array($result)) {
                            $clienteTMP = $this->procesa_cliente($row[2]);
                            $campaniaTMP = $row[1];
                            $agenteTMP = $row[0];
                            $latenciaTMP = array(
                                "usuario" =>$agenteTMP,
                                "latencia_telefonia" => $row[3],
                                "latencia_dialvox" => $row[4],                                
                                "ip_telefonia" =>$row[5],
                                "ip_web" => $row[6]
                            );                
                            $posicionClientes = -1;
                            for($i = 0; $i < count($salida["Clientes"]);$i++){
                                if(strcmp($salida["Clientes"][$i]["nombre"], $clienteTMP) === 0){
                                    $posicionClientes = $i;
                                    break;
                                }
                            }
                            if($posicionClientes == -1){     
                                $salida["Clientes"][] = array(
                                    "nombre" => $clienteTMP,
                                    "campanias" => array()
                                );                                
                                $posicionClientes = count($salida["Clientes"])-1;
                            }              
                            $posicionCampanias = -1;
                            for($i = 0; $i < count($salida["Clientes"][$posicionClientes]["campanias"]);$i++){
                                if(strcmp($salida["Clientes"][$posicionClientes]["campanias"][$i]["nombre"], $campaniaTMP) === 0){
                                    $posicionCampanias = $i;
                                    break;
                                }
                            }
                            if($posicionCampanias == -1){     
                                 $salida["Clientes"][$posicionClientes]["campanias"][] = array(
                                    "nombre" => $campaniaTMP,
                                    "agentes" => array()
                                );  
                                $posicionCampanias = count($salida["Clientes"][$posicionClientes]["campanias"])-1;
                            }
                            $salida["Clientes"][$posicionClientes]["campanias"][$posicionCampanias]["agentes"][] = $latenciaTMP;                            
                            $salida["Latencias"][] = $latenciaTMP;
                        }
                        if($esRoot){
                            $sal["Carriers"] = array();
                            $query = "SELECT id, Troncal, Estado, Latencia, IP FROM dialvox_latencia_troncales";
                            $result = sv_mysqli_query($con, $query);
                            while ($row = sv_mysqli_fetch_array($result)) {
                                $salida["Troncales"][] = array(
                                    "troncal" => $row[1],
                                    "estado" => $row[2],
                                    "latencia" => $row[3],
                                    "ip" => $row[4]
                                );
                            }                            
                        }
                        $sal["Estado"] = "ok";
                        sv_mysqli_close($con); 
                    }else{
                        $salida["Estado"] = "error";
                        $salida["Descripcion"] = "Se requieren privilegios de administrador"; 
                    }                    
                }                
            }            
        }        
        $this->output->set_output(json_encode($salida));
    }    
    public function index()
    {
    }
}
