<?php

require_once "BASEPATH.php";
require_once 'Clases/UsuarioDatos.php';
require_once 'Clases/Usuario.php';
require_once 'Clases/Cliente.php';

class Monitoreo extends MY_Controller{
    public function getLatencias(){        
        include_once RUTA_APP . 'Conexion.php';
        $salida = array();
        if(!isset($_POST["usuario"]) or !isset($_POST["password"])){
            $salida["Estado"] = "error";
            $salida["Descripcion"] = "Usuario o contraseña no enviada";            
        }else{            
            $usuario = $_POST["usuario"];
            $password = $_POST["password"];
            if(empty($usuario) || empty($password)){
                $salida["Estado"] = "error";
                $salida["Descripcion"] = "Usuario o contraseña no enviada"; 
            }else{
                $usuarioEnSistema = UsuarioDatos::getUsuarioByUsuarioAndPassword($usuario, $password);
                if($usuarioEnSistema == null){
                    $salida["Estado"] = "error";
                    $salida["Descripcion"] = "Usuario o contraseña incorrectos"; 
                }else{                    
                    $cliente = $usuarioEnSistema->getCliente();
                    $esRoot = false;                       
                    if ($cliente->esRoot() || strcmp($cliente->getId(), "ADMIN") === 0)
                        $esRoot = true;
                    if(str_contains($cliente->getId(), "_ADMIN") || $esRoot){
                        $con = getConnection();
                        $agregadoQuery = "";                                        
                        if(!$esRoot){
                            $agregadoQuery = "usuario IN (SELECT user from vicidial_users where user_group = '".$cliente->getId()."_AGENTES') AND ";
                        }
                        $query = "SELECT usuario,latencia_telefonia, latencia_dialvox, ip_telefonia, ip_web FROM dialvox_latencias WHERE ".$agregadoQuery." TIME_TO_SEC(TIMEDIFF(NOW(), fecha_telefonia)) < 60";                        
                        $result = sv_mysqli_query($con, $query);
                        $salida["Latencias"] = array();
                        while ($row = sv_mysqli_fetch_array($result)) {
                            $salida["Latencias"][] = array(
                                "usuario" => $row[0],
                                "latencia_telefonia" => $row[1],
                                "latencia_dialvox" => $row[2],                                
                                "ip_telefonia" =>$row[3],
                                "ip_web" => $row[4]
                            );
                        }
                        if($esRoot){
                            $sal["Carriers"] = array();
                            $query = "SELECT id, Troncal, Estado, Latencia, IP FROM dialvox_latencia_troncales";
                            $result = sv_mysqli_query($con, $query);
                            while ($row = sv_mysqli_fetch_array($result)) {
                                $salida["Troncales"][] = array(
                                    "troncal" => $row[1],
                                    "estado" => $row[2],
                                    "latencia" => $row[3],
                                    "ip" => $row[4]
                                );
                            }                            
                        }
                        $sal["Estado"] = "ok";
                        sv_mysqli_close($con); 
                    }else{
                        $salida["Estado"] = "error";
                        $salida["Descripcion"] = "Se requieren privilegios de administrador"; 
                    }                    
                }                
            }            
        }        
        $this->output->set_output(json_encode($salida));
    }    
    public function index()
    {
    }
}
