<?php
class TelefonoDID
{
    private $id;
    private $cliente;
    private $didExtension;
    private $activo;
    private $descripcion;
    private $grabar;
    private $ruta;
    private $agente;
    private $menu;
    private $voicemail;
    private $telefono;
    private $extension;
    private $contextoExtension;
    private $grupoEntrada;
    private $metodoBusqueda;
    private $metodoManejo;
    private $campana;
    private $lista;

    public function getId()
    {
        return $this->id === NULL ? '' : $this->id;
    }

    public function getCliente()
    {
        return $this->cliente;
    }

    public function setCliente($value)
    {
        $this->cliente = $value;
    }

    public function getDidExtension()
    {
        return $this->didExtension === NULL ? '' : $this->didExtension;
    }

    public function setDidExtension($value)
    {
        $this->didExtension = $value;
    }

    public function getActivo()
    {
        return $this->activo === NULL ? 'N' : $this->activo;
    }

    public function setActivo($value)
    {
        $this->activo = $value;
    }

    public function getDescripcion()
    {
        return $this->descripcion === NULL ? '' : $this->descripcion;
    }

    public function setDescripcion($value)
    {
        $this->descripcion = $value;
    }

    public function getGrabar()
    {
        return $this->grabar === NULL ? 'N' : $this->grabar;
    }

    public function setGrabar($value)
    {
        $this->grabar = $value;
    }

    public function getRuta()
    {
        return $this->ruta === NULL ? '' : $this->ruta;
    }

    public function setRuta($value)
    {
        $this->ruta = $value;
    }

    public function getAgente()
    {
        return $this->agente === NULL ? '' : $this->agente;
    }

    public function setAgente($value)
    {
        $this->agente = $value;
    }

    public function getMenu()
    {
        return $this->menu === NULL ? NULL : $this->menu;
    }

    public function setMenu($value)
    {
        $this->menu = $value;
    }

    public function getVoicemail()
    {
        return $this->voicemail === NULL ? '' : $this->voicemail;
    }

    public function setVoicemail($value)
    {
        $this->voicemail = $value;
    }

    public function getTelefono()
    {
        return $this->telefono === NULL ? '' : $this->telefono;
    }

    public function setTelefono($value)
    {
        $this->telefono = $value;
    }

    public function getExtension()
    {
        return $this->extension === NULL ? '' : $this->extension;
    }

    public function setExtension($value)
    {
        $this->extension = $value;
    }

    public function getContextoExtension()
    {
        return $this->contextoExtension === NULL ? '' : $this->contextoExtension;
    }

    public function setContextoExtension($value)
    {
        $this->contextoExtension = $value;
    }

    public function getGrupoEntrada()
    {
        return $this->grupoEntrada === NULL ? '' : $this->grupoEntrada;
    }

    public function setGrupoEntrada($value)
    {
        $this->grupoEntrada = $value;
    }

    public function getMetodoBusqueda()
    {
        return $this->metodoBusqueda === NULL ? '' : $this->metodoBusqueda;
    }

    public function setMetodoBusqueda($value)
    {
        $this->metodoBusqueda = $value;
    }

    public function getMetodoManejo()
    {
        return $this->metodoManejo === NULL ? '' : $this->metodoManejo;
    }

    public function setMetodoManejo($value)
    {
        $this->metodoManejo = $value;
    }

    public function getCampana()
    {
        return $this->campana === NULL ? '' : $this->campana;
    }

    public function setCampana($value)
    {
        $this->campana = $value;
    }

    public function getLista()
    {
        return $this->lista === NULL ? '' : $this->lista;
    }

    public function setLista($value)
    {
        $this->lista = $value;
    }

    // Al constructor se le pasa un arreglo, ya que
    // puede variar las cosas que se inicialicen. Tambien
    // ayuda a dar libertad al llamar al constructor
    public function __construct($construct = array())
    {
        foreach ($construct as $key => $value) {
            $this->{$key} = $value;
        }
    }

    public function setFromArray($construct = array())
    {
        foreach ($construct as $key => $value) {
            $this->{$key} = $value;
        }
    }


    public function toJSON()
    {
        $cliente = $this->cliente;
        if ($cliente != null) {
            $cliente = $cliente->toJSON();
        }

        $menu = $this->menu;
        if ($menu != null) {
            $menu = $menu->toJSON();
        }
        $resp = array();
        $resp["id"] = $this->id;
        $resp["Cliente"] = $cliente;
        $resp["DIDExtension"] = $this->didExtension;

        $resp["Descripcion"] = $this->descripcion;
        $resp["Grabar"] = $this->grabar;
        $resp["Activo"] = $this->activo;
        $resp["Ruta"] = $this->ruta;

        $resp["Agente"] = $this->agente;
        $resp["Menu"] = $menu;
        $resp["Voicemail"] = $this->voicemail;
        $resp["Telefono"] = $this->telefono;

        $resp["Extension"] = $this->extension;
        $resp["Contexto_Extension"] = $this->contextoExtension;

        $resp["GrupoEntrada"] = $this->grupoEntrada;
        $resp["MetodoManejo"] = $this->metodoManejo;
        $resp["MetodoBusqueda"] = $this->metodoBusqueda;
        $resp["Campana"] = $this->campana;
        $resp["Lista"] = $this->lista;

        return $resp;
    }
}
