<?php
namespace Encuesta;

require_once 'Respuesta.php';
require_once 'RespuestaDatos.php';
require_once 'RespuestaCliente.php';
include_once RUTA_APP . 'application/controllers/Clases/Cliente.php';
include_once RUTA_APP . 'application/controllers/Clases/ClienteDatos.php';
include_once RUTA_APP . 'application/controllers/Clases/Campana.php';
include_once RUTA_APP . 'application/controllers/Clases/CampanaDatos.php';
include_once RUTA_APP . 'application/controllers/Clases/Ingroup.php';
include_once RUTA_APP . 'application/controllers/Clases/IngroupDatos.php';
include_once RUTA_APP . 'application/controllers/Clases/Usuario.php';
include_once RUTA_APP . 'application/controllers/Clases/UsuarioDatos.php';
class RespuestaClienteDatos
{
    public static function getRespuestasByPreguntaBetweenDateRange(Pregunta $pregunta, string $fechaInicio, string $fechaFin, $conexion, $campanas = []): array
    {
        $respuesta = array();
        $query = "SELECT id_pregunta,valorRespondido,telefono,lead_id,numeroIntento,group_id,fechaYHora,agente FROM dialvox_respuesta_log WHERE id_pregunta = ? AND DATE(fechaYHora) BETWEEN DATE(?) AND DATE(?) ORDER BY telefono, DATE(fechaYHora) ASC";
        if (count($campanas) > 0) {
            $query = "SELECT id_pregunta,valorRespondido,telefono,lead_id,numeroIntento,group_id,fechaYHora,agente FROM dialvox_respuesta_log WHERE id_pregunta = ? AND DATE(fechaYHora) BETWEEN DATE(?) AND DATE(?) AND group_id IN (" . implode(",", $campanas) . ") ORDER BY telefono, DATE(fechaYHora) ASC";
        }
        if ($stmt = $conexion->prepare($query)) {
            $id = $pregunta->getId();
            $stmt->bind_param("iss", $id, $fechaInicio, $fechaFin);
            $stmt->execute();
            $stmt->bind_result($id_pregunta, $valorRespondido, $telefono, $lead_id, $numeroDeIntento, $group_id, $fechaYHora, $agente);
            $ids = array();
            $lastINT = -1;
            while ($stmt->fetch()) {
                $ids[] = array($id_pregunta, $valorRespondido, $telefono, $lead_id, $numeroDeIntento, $group_id, $fechaYHora, $agente);
            }
            $stmt->close();
            $respuestasDeLaPregunta = RespuestaDatos::getRespuestasByPregunta($pregunta, $conexion);
            $campanas = array();
            $usuarios = array();
            for ($i = 0; $i < count($ids); $i++) {
                $id_pregunta = $ids[$i][0];
                $valorRespondido = $ids[$i][1];
                $telefono = $ids[$i][2];
                $lead_id = $ids[$i][3];
                $numeroDeIntento = $ids[$i][4];
                $group_id = $ids[$i][5];
                $fechaYHora = $ids[$i][6];
                $agente = $ids[$i][7];

                // Recordando campanas ya consultadas
                if (!isset($campanas[$group_id])) {
                    $campana = \CampanaDatos::getCampanaById($group_id);
                    if ($campana == null) {
                        $campanaTmp = \IngroupDatos::getIngroupById($group_id);
                        if ($campanaTmp == null) {
                            $campana = new \Campana("0", new \Cliente(0, "N/A"), utf8_decode("Sin campaña"));
                        } else {
                            $campana = new \Campana($campanaTmp->getId(), $campanaTmp->getCliente(), $campanaTmp->getNombre());
                        }
                    }
                    $campanas[$group_id] = $campana;
                } else {
                    $campana = $campanas[$group_id];
                }
                $resp = null;
                if (is_numeric($valorRespondido)) {
                    for ($j = 0; $j < count($respuestasDeLaPregunta); $j++) {
                        if ($respuestasDeLaPregunta[$j]->getId() == intval($valorRespondido)) {
                            $resp = $respuestasDeLaPregunta[$j];
                            break;
                        }
                    }
                }
                if ($resp == null) {
                    $resp = new Respuesta($lastINT, $pregunta, $valorRespondido, "", 0, 0, "");
                    $lastINT -= 1;
                }

                // Recordando usuarios ya consultados
                $usuarioObj = null;
                if (!isset($usuarios[$agente])) {
                    $usuarioObj = \UsuarioDatos::getUsuarioByUsuario($agente);
                    $usuarios[$agente] = $usuarioObj;
                } else {
                    $usuarioObj = $usuarios[$agente];
                }

                $respuesta[] = new RespuestaCliente($pregunta, $campana, $resp, date_create($fechaYHora), $lead_id, $numeroDeIntento, $telefono, $usuarioObj);
            }
        } else {
            echo ("2" . $conexion->error);
        }
        return $respuesta;
    }
}
