<?php
require_once 'Contexto.php';
require_once RUTA_APP . 'Conexion.php';
require_once 'ClienteDatos.php';
require_once 'Cliente.php';
class ContextoDatos
{
    public static function getContextosByCliente($cliente, $pagina, $limite, $texto)
    {
		if($pagina == null){
			$pagina = 1;
		}
        $con = getConnection();
        $query = "SELECT idContexto,Nombre FROM dialvox_contextos WHERE Cliente='" . limpia($cliente->getId()) . "' AND Nombre LIKE '%" . limpia($texto) . "%' LIMIT " . limpia($pagina * $limite) . "," . limpia($limite);
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, (new Contexto(
                $row["idContexto"], $row["Nombre"]
            ))->toJSON());
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countContextosByCliente($cliente, $texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(idContexto) AS CUENTA FROM dialvox_contextos WHERE Cliente='" . limpia($cliente->getId()) . "' AND Nombre LIKE '%" . limpia($texto) . "%'";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
                sv_mysqli_close($con);
                return $resp;
            } else {
                error_log(mysqli_error($con));
                sv_mysqli_close($con);
                return -1;
            }
        } else {
            error_log(mysqli_error($con));
            sv_mysqli_close($con);
            return -1;
        }
    }

    public static function getContextos($pagina, $limite, $texto)
    {
        $con = getConnection();
        $query = "SELECT idContexto,Nombre,Cliente FROM dialvox_contextos WHERE Nombre LIKE '%" . limpia($texto) . "%' LIMIT " . limpia($pagina * $limite) . "," . limpia($limite);
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, (new Contexto(
                $row["idContexto"], $row["Nombre"], ClienteDatos::getClienteById($row["Cliente"]), ''
            ))->toJSON());
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllContextos()
    {
        $con = getConnection();
        $query = "SELECT idContexto,Nombre FROM dialvox_contextos";
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, (new Contexto(
                $row["idContexto"],
                $row["Nombre"]
            ))->toJSON());
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllContextosByCliente($cliente)
    {
        $con = getConnection();
        $query = "SELECT idContexto,Nombre FROM dialvox_contextos WHERE Cliente = '" . limpia($cliente->getId()) . "'";
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, (new Contexto(
                $row["idContexto"],
                $row["Nombre"]
            ))->toJSON());

        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getContextoById($id)
    {
        $con = getConnection();
        $query = "SELECT * FROM dialvox_contextos WHERE idContexto = '" . $id . "'";
        $resp = null;
        $result = sv_mysqli_query($con, $query);
        if ($row = sv_mysqli_fetch_array($result)) {
            $resp = (new Contexto(
                $row["idContexto"], $row["Nombre"], ClienteDatos::getClienteById($row["Cliente"]), $row["Contenido"]
            ));
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countContextos($texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(idContexto) AS CUENTA FROM dialvox_contextos WHERE Nombre LIKE '%" . limpia($texto) . "%'";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
                sv_mysqli_close($con);
                return $resp;
            } else {
                error_log(mysqli_error($con));
                sv_mysqli_close($con);
                return -1;
            }
        } else {
            error_log(mysqli_error($con));
            sv_mysqli_close($con);
            return -1;
        }
    }
    public static function updateContexto(Contexto $contexto)
    {
        $con = getConnection();

        $query = "UPDATE dialvox_contextos SET
				Nombre = '" . limpia($contexto->getNombre()) . "',
				Contenido = '" . limpia($contexto->getContenido()) . "'
			WHERE idContexto = '" . limpia($contexto->getId()) . "'
			LIMIT 1";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
        } else {
            error_log(mysqli_error($con));
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function insertContexto(Contexto $contexto)
    {
        $con = getConnection();
        $query = "INSERT INTO dialvox_contextos  (Nombre, Contenido, Cliente ) VALUES (
				'" . limpia($contexto->getNombre()) . "',
				'" . limpia($contexto->getContenido()) . "',
				'" . limpia($contexto->getCliente()->getId()) . "')";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
        } else {
            error_log(mysqli_error($con));
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function deleteContexto(Contexto $contexto)
    {
        $con = getConnection();
        $query = "DELETE FROM dialvox_contextos WHERE idContexto = '" . $contexto->getId() . "' LIMIT 1 ";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
        } else {
            error_log(mysqli_error($con));
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
}
