<?php

require_once "BASEPATH.php";
require_once 'Clases/ClienteDatos.php';
require_once 'Clases/ExtensionDatos.php';
include_once RUTA_APP . 'Sesiones.php';
class Telefono extends MY_Controller
{
    public function listarExtensiones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $texto = isset($_POST["texto"]) ? $_POST["texto"] : "";
            $pagina = $_POST["pagina"] == -1 ? 0 : $_POST["pagina"];
            $limite = 15;
            $extensiones = array();
            $cuenta = 0;
            if ($cliente->getId() != -1) {
                $extensiones = ExtensionDatos::getExtensionesByCliente($cliente, $texto, $pagina, $limite);
                $cuenta = ExtensionDatos::countExtensionesByCliente($cliente, $texto);
            } else {
                $extensiones = ExtensionDatos::getExtensiones($texto, $pagina, $limite);
                $cuenta = ExtensionDatos::countExtensiones($texto);
            }
            $sal["Cuenta"] = $cuenta;
            $sal["Extensiones"] = array();
            for ($i = 0; $i < count($extensiones); $i++) {
                $sal["Extensiones"][] = $extensiones[$i]->toJSON();
            }
            $sal["Estado"] = "ok";
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function seleccionarExtensiones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $extensiones = array();
            $cuenta = 0;
            if ($cliente->getId() == -1) {
                $extensiones = ExtensionDatos::getAllExtensiones();
            } else {
                $extensiones = ExtensionDatos::getAllExtensionesByCliente($cliente);
            }
            $sal["Cuenta"] = $cuenta;
            $sal["Extensiones"] = array();
            for ($i = 0; $i < count($extensiones); $i++) {
                $sal["Extensiones"][$i] = $extensiones[$i]->toJSON();
            }
            $sal["Estado"] = "ok";
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function agregrarExtension()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["cliente"]);
            if (ExtensionDatos::getExtensionByExtension($_POST["extension"]) != null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionExist");
            } else {
                $extension = new Extension(
                    $_POST["extension"],
                    $_POST["numeroPlanDeMarcacion"],
                    $_POST["voicemail"],
                    $_POST["identificadorSaliente"],
                    $cliente,
                    SERVER_IP_REAL,
                    $_POST["usuario"],
                    $_POST["pass"],
                    "ACTIVE",
                    $_POST["activa"],
                    $_POST["nombre"],
                    $_POST["protocolo"],
                    "",
                    $_POST["tipoTelefono"]
                );
                if (ExtensionDatos::addExtension($extension) == 0) {
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionAdd");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function eliminarExtension()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $extension = ExtensionDatos::getExtensionByExtension($_POST["extension"]);
            if ($extension == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionNotExist");
            } else {
                if ($cliente->getId() == -1 || $cliente->getId() == $extension->getCliente()->getId()) {
                    if (ExtensionDatos::deleteExtension($extension) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionDelete");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosTelefonoExtensionDelete");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function obtenerExtension()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $extension = ExtensionDatos::getExtensionByExtension($_POST["extension"]);
            if ($extension != null && ($cliente->getId() == -1 || $extension->getCliente()->getId() == $cliente->getId())) {
                $sal["Extension"] = $extension->toJSON();
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosTelefonoExtensionView");
            }

        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function editarExtension()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $extension = ExtensionDatos::getExtensionByExtension($_POST["extension"]);
            if ($extension != null) {
                if ($cliente->getId() == -1 || $cliente->getId() == $extension->getCliente()->getId()) {
                    $extension->setNumeroPlanDeMarcacion($_POST["numeroPlanDeMarcacion"]);
                    $extension->setVoicemail($_POST["voicemail"]);
                    $extension->setIdentificadorSaliente($_POST["identificadorSaliente"]);
                    $extension->setUsuario($_POST["usuario"]);
                    $extension->setPassword($_POST["pass"]);
                    $extension->setActiva($_POST["activa"]);
                    $extension->setNombre($_POST["nombre"]);
                    $extension->setProtocolo($_POST["protocolo"]);
                    if (ExtensionDatos::updateExtension($extension) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionEdit");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosTelefonoExtensionEdit");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionNotExist");
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function deshabilitarExtension()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('telefono', "spanish");
                break;
            case "en":
                $this->lang->load('telefono', "english");
                break;
            default:
                $this->lang->load('telefono', "spanish");
                break;
        }

        header('Content-type: application/json');
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $extension = ExtensionDatos::getExtensionByExtension($_POST["extension"]);
            if ($extension != null) {
                if ($cliente->getId() == -1 || $cliente->getId() == $extension->getCliente()->getId()) {
                    $activo = $extension->getActiva();
                    if ($activo == "Y") {
                        $extension->setActiva("N");
                    } else {
                        $extension->setActiva("Y");
                    }
                    if (ExtensionDatos::updateExtension($extension) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionEdit");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosTelefonoExtensionEdit");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoExtensionNotExist");
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_errorTelefonoLogueado");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function index()
    {
        $this->load->view('extensiones/head');
        $this->load->view('extensiones/vw_extensiones');
        $this->load->view('extensiones/foot');
    }
}
