<?php

require_once "BASEPATH.php";

class Respuesta extends MY_Controller
{

    public function getRespuestaSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_respuesta,nombre FROM dialvox_respuesta WHERE id_pregunta='$id_pregunta' ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRespuestas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $pagina = limpia($_POST["pagina"]) - 1;
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_respuesta,nombre,identificadorDeRespuesta FROM dialvox_respuesta WHERE id_pregunta='$id_pregunta' LIMIT " . ($pagina * 10) . ",10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $query = "SELECT COUNT(id_respuesta) AS CANT FROM dialvox_respuesta WHERE id_pregunta='$id_pregunta' ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteRespuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $id_respuesta = limpia($_POST["id_respuesta"]);

            $query = "DELETE FROM dialvox_respuesta WHERE id_pregunta='$id_pregunta' AND id_respuesta='$id_respuesta'";
            sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addRespuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $nombre = limpia($_POST["nombre"]);
            $identificadorDeRespuesta = limpia($_POST["identificadorDeRespuesta"]);
            $peso = limpia($_POST["peso"]);
            $tipoDeAccion = limpia($_POST["tipoDeAccion"]);
            $valorDeAccion = limpia($_POST["valorDeAccion"]);

            $query = "INSERT INTO dialvox_respuesta(id_pregunta,nombre,identificadorDeRespuesta,peso,tipoDeAccion,valorDeAccion) VALUES('$id_pregunta','$nombre','$identificadorDeRespuesta','$peso','$tipoDeAccion','$valorDeAccion')";
            sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editRespuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_respuesta = limpia($_POST["id_respuesta"]);
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $nombre = limpia($_POST["nombre"]);
            $identificadorDeRespuesta = limpia($_POST["identificadorDeRespuesta"]);
            $peso = limpia($_POST["peso"]);
            $tipoDeAccion = limpia($_POST["tipoDeAccion"]);
            $valorDeAccion = limpia($_POST["valorDeAccion"]);

            $query = "UPDATE dialvox_respuesta SET id_pregunta='$id_pregunta',nombre='$nombre',identificadorDeRespuesta='$identificadorDeRespuesta',peso='$peso',tipoDeAccion='$tipoDeAccion',valorDeAccion='$valorDeAccion' WHERE id_respuesta='$id_respuesta'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRespuestaDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_respuesta = limpia($_POST["id_respuesta"]);
            $query = "SELECT * FROM dialvox_respuesta WHERE id_respuesta='$id_respuesta'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Respuesta"] = $row;
                $sal["Estado"] = "ok";

            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRespuestaLog()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('respuesta', "spanish");
                break;
            case "en":
                $this->lang->load('respuesta', "english");
                break;
            default:
                $this->lang->load('respuesta', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $query = "SELECT * FROM dialvox_respuesta_log WHERE id_pregunta='$id_pregunta'";
            $result = sv_mysqli_query($con, $query);
            $sal["Registros"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('respuesta/head');
        $this->load->view('respuesta/vw_categorias');
        $this->load->view('respuesta/foot');
    }
}
