<?php

require_once 'FrameAgente.php';
require_once 'ClienteDatos.php';
require_once 'SimpleQuery.php';
require_once RUTA_APP . 'Conexion.php';

class FrameAgenteDatos
{

    const TABLE = "dialvox_frame_agente";

    public static function getById($id)
    {
        $res = SimpleQuery::exec(
            SimpleQuery::simpleSelect(
                "id,Titulo,Campana,Cliente,Url,Estatico",
                self::TABLE,
                "id='" . limpia($id) . "'"
            )
        );
        if (isset($res["result"])) {
            if ($row = sv_mysqli_fetch_array($res["result"])) {
                $res["result"] = new FrameAgente(
                    $row["Url"],
                    $row["Campana"],
                    $row["Titulo"],
                    ClienteDatos::getClienteById($row["Cliente"]),
                    $row["id"],
                    $row["Estatico"]
                );
            } else {
                $res["result"] = NULL;
            }
        }
        return $res;
    }

    public static function getFramesByCampaign($campaign, $cliente)
    {
        $res = SimpleQuery::exec(
            SimpleQuery::simpleSelect(
                "id,Url,Campana,Cliente,Titulo,Estatico",
                self::TABLE,
                "Campana='$campaign' AND Cliente='$cliente'"
            )
        );
        if (isset($res["result"])) {
            $data = array();
            while ($row = sv_mysqli_fetch_array($res["result"])) {
                array_push($data, new FrameAgente(
                    $row["Url"],
                    $row["Campana"],
                    $row["Titulo"],
                    ClienteDatos::getClienteById($row["Cliente"]),
                    $row["id"],
                    $row["Estatico"]
                ));
            }
            $res["result"] = $data;
        }
        return $res;
    }

    /*
            
        Codigo temporal, remover cuando haya clase Dialvox
        se pase a orienta a objetos completamente
        ====================================================
    */
    public static function compruebaCampana($campana, $cliente)
    {
        $res = SimpleQuery::exec(
            SimpleQuery::simpleSelect(
                "campaign_id",
                "vicidial_campaigns",
                "campaign_id='" . $campana . "' AND user_group='" . $cliente . "'"
            )
        );
        if (isset($res["result"])) {
            if (!sv_mysqli_fetch_array($res["result"])) {
                $res["result"] = NULL;
            }
        }
        return $res;
    }
    //  ====================================================

    public static function insertAgentFrame($agentFrame)
    {
        if (self::getById($agentFrame->getId())["result"] === NULL) {
            if (self::compruebaCampana(
                $agentFrame->getCampana(), 
                $agentFrame->getCliente()->getId())
            ) {
                $res = SimpleQuery::exec(
                    SimpleQuery::insert(
                        self::TABLE,
                        array(
                            "Url" => $agentFrame->getURL(),
                            "Titulo" => $agentFrame->getTitulo(),
                            "Campana" => $agentFrame->getCampana(),
                            "Cliente" => $agentFrame->getCliente()->getId(),
                            "Estatico" => $agentFrame->getEstatico()
                        )
                    ),
                    TRUE
                );
                if (isset($res["result"])) {
                    $res["result"] = $agentFrame->getURL();
                }
                return $res;
            } else {
                return array(
                    "status" => "error",
                    "error" => "desc_campanaFrameInexistente"
                );
            }
        } else {
            return array(
                "status" => "error",
                "error" => "desc_frameCrearExistente"
            );
        }
    }

    public static function updateAgentFrame($agentFrame, $cliente)
    {
        $tmpAgentFrame = self::getById($agentFrame->getId())["result"];
        if ($tmpAgentFrame !== NULL) {
            if (
                $cliente->getId() !== "-1" && 
                $cliente->getId() !== -1 && 
                $tmpAgentFrame->getCliente()->getId() === $cliente->getId()
            ) {
                if (self::compruebaCampana(
                    $agentFrame->getCampana(), 
                    $agentFrame->getCliente()->getId())
                ) {
                    $res = SimpleQuery::exec(
                        SimpleQuery::update(
                            self::TABLE,
                            array(
                                "Url" => $agentFrame->getURL(),
                                "Titulo" => $agentFrame->getTitulo(),
                                "Estatico" => $agentFrame->getEstatico()
                            ),
                            "id='" . limpia($agentFrame->getId()) . "'"
                        )
                    );
                    return $res;
                } else {
                    return array(
                        "status" => "error",
                        "error" => "desc_campanaFrameInexistente"
                    );
                }
            } else {
                return array(
                    "status" => "error",
                    "error" => "desc_permisosFrame"
                );
            }
        } else {
            return array(
                "status" => "error",
                "error" => "desc_frameEditarInexistente"
            );
        }
    }

    public static function deleteAgentFrame($cliente,$id="")
    {
        $agentFrame = self::getById($id)["result"];
        if ($agentFrame !== NULL) {
            if (
                $cliente->getId() !== "-1" && 
                $cliente->getId() !== -1 && 
                $agentFrame->getCliente()->getId() === $cliente->getId()
            ) {
                return SimpleQuery::exec("DELETE FROM " . self::TABLE . " WHERE id='" . limpia($id) . "'");
            } else {
                return array(
                    "status" => "error",
                    "error" => "desc_permisosFrame"
                );
            }
        } else {
            return array(
                "status" => "error",
                "error" => "desc_frameEliminarInexistente"
            );
        }
    }
}
