const grupoDefault = GRUPO_AGENTE;
const agentesActuales = {};

/**
 * .modal-transferencia-contenedor Contenedor de todo lo de transferencias a agente
 * #modal-transferencia-grupos Select de los grupos de agente
 * .modal-transferencia-contenedor-agente Contendor del listado de botones de agentes
 * #modal-transferencia-mensaje Mensaje para cualquiera de las dos transferencias
 * .modal-transferencia Modal para las transferencias a grupos o agentes
 */

function mostrarTransferenciaAgente() {
	// Quitar d-none de contenedor modal-transferencia-agente
	$('.modal-transferencia-agente').modal();

	document
		.querySelector('.modal-transferencia-contenedor')
		.classList.remove('d-none');
}

function ocultarTransferenciaAgente() {
	$('.modal-transferencia-agente').modal('hide');
	mensajeSeleccionLimpiar();
}

/**
 * Cargar los grupos de agentes en listados de botones
 * @param {{Registros: {id: string, Grupo: string}[]}} grupos Grupos[]
 */
function cargarGrupoAgentes(grupos) {
	const select = document.querySelector('#modal-transferencia-grupos');
	select.innerHTML = ''; // Limpiar opciones existentes

	if (grupoDefault === '') {
		const option = document.createElement('option');
		option.value = '';
		option.textContent = 'Selecciona un grupo';
		select.appendChild(option);
	}

	grupos.Registros.forEach((grupo) => {
		const option = document.createElement('option');
		option.value = grupo.id;
		option.textContent = grupo.Grupo;
		select.appendChild(option);
	});

	select.value = grupoDefault;
}

/**
 *
 * @param {{Registros: {usuario: string, nombre: string, estado: string}[]}} agentes
 */
function cargarAgentes(agentes, listener) {
	const contenedor = document.querySelector(
		'.modal-transferencia-contenedor-agentes'
	);
	contenedor.innerHTML = ''; // Limpiar agentes existentes
	Object.keys(agentesActuales).forEach((key) => delete agentesActuales[key]); // Limpiar mapa de agentesActuales

	if (!agentes.Registros || agentes.Registros.length === 0) {
		contenedor.innerHTML = 'No hay agentes disponibles para transferencia';
	}

	agentes.Registros.forEach((agente) => {
		const boton = document.createElement('button');
		boton.name = agente.usuario;
		boton.textContent = agente.nombre;
		boton.setAttribute('data-estado', agente.estado);
		boton.classList.add('btn');
		boton.classList.add('p-1');

		boton.setAttribute('data-toggle', 'tooltip');
		boton.setAttribute('data-placement', 'top');

		switch (agente.estado) {
			case 'PAUSED':
				boton.classList.add('btn-warning');
				boton.setAttribute('title', 'Pausado');
				break;
			case 'INCALL':
				boton.classList.add('btn-success');
				boton.setAttribute('title', 'En llamada');
				break;
			case 'READY':
				boton.classList.add('btn-info');
				boton.setAttribute('title', 'Disponible');
				break;

			default:
				boton.classList.add('btn-secondary');
				break;
		}

		contenedor.appendChild(boton);

		boton.addEventListener('click', () =>
			listener(boton, agente.usuario, agente.nombre)
		);

		agentesActuales[agente.usuario] = agente;
	});

	$('[data-toggle="tooltip"]').tooltip();
}

/**
 *
 * @param {HTMLButtonElement} boton
 */
function seleccionarBoton(boton) {
	boton.classList.remove('btn-secondary');
	boton.classList.remove('btn-info');
	boton.classList.remove('btn-warning');
	boton.classList.remove('btn-success');

	boton.classList.add('btn-primary');
	boton.style = 'transform: scale(1.1)';
}

/**
 *
 * @param {HTMLButtonElement} boton
 */
function deseleccionarBoton(boton) {
	boton.classList.remove('btn-secondary');
	boton.classList.remove('btn-info');
	boton.classList.remove('btn-warning');
	boton.classList.remove('btn-success');
	boton.classList.remove('btn-primary');
	boton.style = 'transform: scale(1)';

	const estado = boton.getAttribute('data-estado');
	switch (estado) {
		case 'PAUSED':
			boton.classList.add('btn-warning');
			break;
		case 'INCALL':
			boton.classList.add('btn-success');
			break;
		case 'READY':
			boton.classList.add('btn-info');
			break;

		default:
			boton.classList.add('btn-secondary');
			break;
	}
}

function actualizarGrupo(listener) {
	const select = document.querySelector('#modal-transferencia-grupos');
	select.addEventListener('change', (event) => {
		listener(event.target.value);
	});
}

/**
 *
 * @param {(usuario: string, nombre: string) => void} listener
 */
function seleccionarAgente(listener) {
	const botones = document.querySelectorAll(
		'.modal-transferencia-contenedor-agentes button'
	);
	botones.forEach((boton) => {
		boton.addEventListener('click', () => {
			listener(boton.name, boton.textContent);
		});
	});
}

function mensajeSeleccion(nombre) {
	const mensaje = document.querySelector('#modal-transferencia-mensaje');
	mensaje.textContent = `Vuelve a hacer clic para confirmar la transferencia a ${nombre}`;
}

function mensajeSeleccionLimpiar() {
	const mensaje = document.querySelector('#modal-transferencia-mensaje');
	mensaje.textContent = 'Haz clic en el agente para transferir la llamada';
}

function transferirAAgente(agente) {
	transfiereLocalCloser(2, agente);
	$('.modal-transferencia-agente').modal('hide');
}

function abrirTransferencia(listener) {
	$('.agentesTransfer').click((e) => {
		Swal.close();
		listener(e);
	});
}

(function (args) {
	function init({
		abrirTransferencia,
		cargarGrupoAgentes,
		cargarAgentes,
		grupoDefault,
		actualizarGrupo,
		mensajeSeleccion,
		mensajeSeleccionLimpiar,
		seleccionarBoton,
		deseleccionarBoton,
		seleccionarAgente,
		transferirAAgente,
		mostrarTransferenciaAgente,
		ocultarTransferenciaAgente,
	}) {
		this.grupo = grupoDefault;
		this.botonActual = null;
		this.agente = {
			id: '',
			nombre: '',
		};

		abrirTransferencia((e) => {
			prevenirEventoHTML(e);

			mostrarTransferenciaAgente();

			obtenerGruposDeAgente((grupos) => {
				cargarGrupoAgentes(grupos);
				obtenerAgentesParaTransferencia(this.grupo, (agentes) => {
					this.botonActual = null;
					cargarAgentes(agentes, listenerAgente);
					this.limpiarAgente();
				});
			});
		});

		actualizarGrupo((valor) => {
			obtenerAgentesParaTransferencia(valor, (agentes) => {
				mensajeSeleccionLimpiar();
				this.botonActual = null;
				cargarAgentes(agentes, listenerAgente);
				this.limpiarAgente();
			});
		});

		this.limpiarAgente = function () {
			this.agente.id = '';
			this.agente.nombre = '';
		};

		const listenerAgente = (button, agente, nombre) => {
			if (this.agente.id === agente) {
				transferirAAgente(agente);
				console.log('transferir! a', agente);
				ocultarTransferenciaAgente();
				this.limpiarAgente();
			} else {
				mensajeSeleccion(nombre);
				if (this.botonActual) {
					deseleccionarBoton(this.botonActual);
				}
				seleccionarBoton(button);
				this.botonActual = button;
				this.agente.id = agente;
				this.agente.nombre = nombre;
			}
		};

		function obtenerGruposDeAgente(cb, cb_err) {
			manejarPeticionEstandar(
				$.post(
					'/' +
						RUTA_MAESTRA +
						'/index.php/GrupoAgentes/getGroupsSelect'
				),
				cb,
				cb_err
			);
		}

		function obtenerAgentesParaTransferencia(grupo, cb, cb_err) {
			manejarPeticionEstandar(
				$.post(
					'/' +
						RUTA_MAESTRA +
						'/index.php/Usuarios/getAgentesParaTransferencia',
					{ grupo }
				),
				cb,
				cb_err
			);
		}
	}

	window.initTransferenciaAgentes = function () {
		init(args);
	};
})({
	abrirTransferencia: abrirTransferencia, // Boton para abrir transferencias de agentes
	cargarGrupoAgentes: cargarGrupoAgentes,
	cargarAgentes: cargarAgentes,
	grupoDefault,
	seleccionarAgente,
	mensajeSeleccion,
	actualizarGrupo,
	transferirAAgente,
	mostrarTransferenciaAgente,
	mensajeSeleccionLimpiar,
	seleccionarBoton,
	deseleccionarBoton,
	ocultarTransferenciaAgente,
});
