<?php
$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}
?>


<div id="mainTwo">
	<div class="">
		<section id="">
			<div class="container">
				<div class="row">
					<div class="col s12" style="margin-top: 70px;">
						<div class="col s12 card-panel black-text white z-depth-3 hoverable" style="">
							<h4>{{traducirFrase("Reporte Entrante por Hora de Servicio")}}</h4>
							<div class="input-field col s2">
								<label for="pickDate1">{{traducirFrase("Fecha")}}</label>
								<input type="text" autocomplete="off" start-date="new Date()" class=" datepicker-here" data-range="true"
										data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd"
										data-language="<?=$idioma;?>"
										class="datepicker-here" id="pickDate"/>
							</div>
							<div class="input-field col s3">
								<label class="active" >{{traducirFrase("Tipo de visualizacion")}}</label>
								<select class="browser-default" v-model="tipoVisualizacion">
									<option :value="'normal'">General</option>
									<option :value="'desglose'">{{traducirFrase("Desglose por hora")}}</option>
								</select>
							</div>
							<div class="input-field col s3">
								<label for="select-ingroups" class="active">
									{{traducirFrase("Grupo de entrada")}}
								</label>
								<select id="select-ingroups" multiple v-model="filtroGrupo">
									<option value="" selected disabled>{{traducirFrase("Seleccionar los grupos")}}</option>
									<option
										v-for="item in selectGrupos"
										:key="item.value"
										:value="item.value"
									>{{ item.label }}</option>
								</select>
								<span class="helper-text">
									{{traducirFrase("Si no seleccionas un grupo de entrada se buscara en todos los grupos.")}}
								</span>
							</div>
							<div class="input-field col s2">
								<label for="archived">
									<input type="checkbox" id="archived" class="input-field">
									<span>{{traducirFrase("Información archivada")}}</span>
								</label>
							</div>
							<div class="input-field col s2 superCentrado">
								<button class="btn btn-success btnW" v-bind:title="traducirFrase('Generar reporte')" onclick="cargaPeticion()"><i class="material-icons">done</i></button>&nbsp;&nbsp;
								<a class="btn btnW" href="" v-bind:title="traducirFrase('Descargar reporte')" id='descargarBoton'><span><i class="material-icons">get_app</i></span></a> <br><br>
							</div>
						</div>
					</div>
					<div class='col s12'>
						<div class="col s12">
							<div class="card-panel white z-depth-5 hoverable container">
								<div class='row'>
									<div class="col s12">
										<h5>
										{{
											tipoVisualizacion === "normal" ?
												traducirFrase("Resumen de Reporte por Hora") :
												traducirFrase("Desglose por hora")
										}}
										</h5>
									</div>
								</div>
								<div class='row' :hidden="tipoVisualizacion !== 'normal'">
									<div class='col s7 mt-2'>
										<div class="row">
											<div class="col s12">
												<table class='striped highlight centered responsive-table bordA'>
													<thead>
														<tr>
															<th class="btnW1" nowrap>{{traducirFrase("Grupo")}}</th>
															<th class="btnW2" nowrap>Total</th>
															<th class="btnW3" nowrap>{{traducirFrase("Cont.")}}</th>
															<th class="btnW5" nowrap>{{traducirFrase("Tiem.")}}</th>
															<th class="btnW6" nowrap>{{traducirFrase("T. prom.")}}</th>
															<th class="btnW7" nowrap>{{traducirFrase("T. cola")}}</th>
															<th class="btnW8" nowrap>{{traducirFrase("T.c. prom.")}}</th>
															<th class="btnW9" nowrap>{{traducirFrase("Max. t. cola")}}</th>
															<th class="btnW10" nowrap>{{traducirFrase("Aban.")}}</th>
														</tr>
													</thead>
													<tbody id='idtbody' >
														<tr>
															<td colspan='3'><img id="stemen" src="<?=IMG_ADMIN;?>spinner.gif"></td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
									<div id="highChart5" :style="tipoVisualizacion === 'normal' ?'margin-top:0;height:600px;' : 'margin-top: 0;height: 0px;'" class="col s5 tablitasW"></div>
								</div>
								<div class="row" :hidden="tipoVisualizacion === 'normal'">
									<div class="col s12">
										<h5>{{traducirFrase("Acumulado")}}</h5>
										<table-dialvox
											:headers="headers"
											:data="totales"
											:hsearch="true"
										></table-dialvox>
									</div>
								</div>
								<div class="row" :hidden="tipoVisualizacion === 'normal'">
									<div class="col s12" v-for="grupo in gruposFiltrados">
										<h5>{{ grupo.nombre }}</h5>
										<table-dialvox
											:headers="headers"
											:data="grupo.registros"
											:hsearch="true"
										></table-dialvox>
									</div>
								</div>
								<br><br>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>
<!-- END MAIN -->
<!-- //////////////////////////////////////////////////////////////////////////// -->
<!-- START FOOTER -->
<?php require_once UTILS_PATH . 'footer.php';?>
<!-- END FOOTER -->
<!-- ================================================
    Scripts
    ================================================ -->
<!-- jQuery Library -->
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>jquery-3.2.1.min.js"></script>
<!--materialize js-->
<script type="text/javascript" src="<?=JS_ADMIN;?>materialize.min.js"></script>
<!--scrollbar-->
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>perfect-scrollbar/perfect-scrollbar.min.js"></script>
<!-- chartjs -->
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>chartjs/chart.min.js"></script>
<!-- sparkline -->
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>sparkline/jquery.sparkline.min.js"></script>
<!-- google map api -->
<script type="text/javascript" src="<?=JS_ADMIN;?>maps.js"></script>
<!--jvectormap-->
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<script type="text/javascript" src="<?=VENDORS_ADMIN;?>jvectormap/vectormap-script.js"></script>
<!--google map-->

<!--plugins.js - Some Specific JS codes for Plugin Settings-->
<script type="text/javascript" src="<?=JS_ADMIN;?>plugins.js"></script>
<!--card-advanced.js - Page specific JS-->
<script type="text/javascript" src="<?=JS_ADMIN;?>scripts/dashboard-analytics.js"></script>
<!--custom-script.js - Add your own theme custom JS
    <script type="text/javascript" src="<?=JS_ADMIN;?>custom-script.js"></script>-->
<script src="<?=JS_ADMIN;?>vue.js"></script>
<script src="<?=JS_ADMIN;?>Chart.min.js"></script>
<script src="<?=JS_ADMIN;?>gauge.min.js"></script>
<script src="<?=JS_ADMIN;?>raphael.js"></script>
<script src="<?=JS_ADMIN;?>justgage.js"></script>
<script src="<?=JS_ADMIN;?>datepicker.js"></script>
<script src="<?=JS_ADMIN;?>i18n/datepicker.es.js"></script>
<script src="<?=JS_ADMIN;?>i18n/datepicker.en.js"></script>

<script type="text/javascript" src="<?=LIB_JS;?>highcharts/stock/highstock.js"></script>
<script src="<?=LIB_JS;?>highcharts/highcharts-3d.js"></script>
<script src="<?=LIB_JS;?>highcharts/modules/cylinder.js"></script>
<script src="<?=LIB_JS;?>highcharts/modules/exporting.js"></script>
<script src="<?=LIB_JS;?>highcharts/modules/export-data.js"></script>
<script src="<?=LIB_JS;?>highcharts/modules/accessibility.js"></script>
<script src="<?=LIB_JS;?>highcharts/modules/more.js"></script>

<?php require_once "script.php";?>

</body>

<!-- Mirrored from pixinvent.com/materialize-material-design-admin-template/html/horizontal-menu/ by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 07 Aug 2018 16:55:15 GMT -->

</html>
