let vue_obj;
(function () {
    const controlador = "Contextos"
    const app = new Vue({
        el: "#main",
        data() {
            return {
                // Variables para la tabla
                registros: [],
                loading: true,
                headers: [
                    { label: 'ID', key: "id" },
                    { label: traducirFrase('Nombre'), key: "nombre" },
                    // { label: 'Cliente', key: "Cliente" },
                ],
                options: [
                    { action: 'edit', tooltip: traducirFrase('Editar el contexto'), icon: 'edit' },
                    { action: 'delete', tooltip: traducirFrase('Eliminar contexto'), icon: 'delete' },
                ],
                // Variables para los modales
                targets: {
                    add: false,
                    edit: false,
                },
                // Registrar
                one: {
                    id: '',
                    nombre: '',
                    nextAgentCall: '',
                    activo: false,
                },
                // Editar
                // Paginacion
                pagina: 1,
                cuenta: 1,
                texto: "",
            }
        },
        methods: {
            load() {
                let self = this
                gen_rpost(controlador + "/getContextos", {
                    pagina: this.pagina - 1,
                    texto: this.texto
                }).then(results => {
                    self.registros = results.Registros
                    self.cuenta = Math.floor((+results.Cant) / 15 + 1)
                    if (results.Cant % 15 == 0) {
                        self.cuenta--
                    }
                    self.loading = false
                }).catch(err => {
                    console.log(err)
                })
            },
            sendData(url, toggle) {
                let self = this
                console.log(this.one)
                handled_rpost(`${controlador}/${url}`, {
                    nombre: this.one.nombre,
                    contenido: this.one.contenido,
                    id: this.one.id
                }).then(res => {
                    self.toggle(toggle)
                    self.load()
                })
                    .catch(err => console.log(err))
            },
            add(url, toggle) {
                this.sendData(url, toggle)
            },
            edit($evt) {
                let self = this
                gen_rpost(controlador + "/getContexto", {
                    id: $evt.id,
                }).then(res => {
                    console.log(res)
                    let { id, nombre, contenido } = res.Contexto
                    self.one = {
                        contenido: contenido,
                        nombre: nombre,
                        id: id
                    }
                    self.toggle('edit')
                }).catch(err => console.log(err))
            },
            del($evt) {
                let self = this
                conf_rpost(controlador + "/deleteContexto", {
                    id: $evt.id
                }, traducirFrase("Continuar esta accion eliminara el contexto seleccionado")).then(result => {
                    self.load()
                }).catch(err => {
                    console.log(err)
                })
            },
            toggle(target) {
                if (target == 'add') {
                    this.one = {
                        nombre: '',
                        contenido: '',
                        id: ''
                    }
                }
                app.targets[target] = !app.targets[target]
            },
        },
        computed: {
            validForm() {
                return this.one.nombre != ''
            }
        },
        watch: {
            pagina() {
                this.load()
            }
        },
        updated() {
            $(".tooltipped").tooltip()
        },
        mounted() {
            let self = this
            setInterval(self.load, 20000)
        },
    })

    app.load()
    vue_obj = app
})()