<h4>{{traducirFrase("Pausa automatica")}}</h4>
<br>
<div class="col px-3" style="display: flex; flex-direction: col; gap: 2rem;flex-direction: column;padding: 2rem;">
    <div class="col s12" v-if="autopausaActiva">
        <div class="input-field row s6">
            <label for="" class="active">{{traducirFrase("Estado de pausa")}}</label>
            <select name="" id="" class="browser-default" v-model="autopausaCodigo">
                <option :value="''" disabled selected>
                    {{traducirFrase("Selecciona un valor")}}
                </option>
                <option
                    v-for="param in estadosPausaAutopausa"
                    :key="param.value"
                    :value="param.value">
                    {{ param.label }}
                </option>
            </select>
            <span class="helper-text">
                {{traducirFrase("Estado de pausa que se activará automaticamente al finalizar una llamada")}}
            </span>
        </div>
    </div>
    <div style="display: flex;gap: 1rem;align-items: center;flex-direction: row;" v-if="autopausaActiva">
        <div class="input-field row s6">
            <label for="" class="active">{{traducirFrase("Tono pendiente")}}</label>
            <select name="" id="" class="browser-default" v-model="autopausaTono">
                <option :value="''" disabled selected>
                    {{traducirFrase("Selecciona un tono")}}
                </option>
                <option value="1">
                    Tono 1
                </option>
                <option value="2">
                    Tono 2
                </option>
                <option value="3">
                    Tono 3
                </option>
                <option value="4">
                    Tono 4
                </option>
            </select>
            <span class="helper-text">
                {{traducirFrase("Con el pausado automatico habilitado, las llamadas en cola emitirán una alerta sonora.")}}
            </span>
        </div>
        <button class="btn wave-effect waves-light btn-small teal-text white" @click="autopausaProbarTono()">
            {{traducirFrase("Probar")}}
        </button>
    </div>
    <div class="col s12" v-else>
        Habilitar el pausado automatico cambia el estado del agente automaticamente una vez terminada cada llamada. Debes seleccionar el estado de pausa y guardar para que los cambios se efectuen.
    </div>
    <div class="row" style="display: flex; justify-content: flex-end; align-items: center; flex-direction: row;gap: 2rem;">
        <button class="waves-effect waves-light btn-small" @click="editarAutopausa()" :disabled="autopausaActiva ? autopausaCodigo === '' || autopausaTono === '' : false">
            {{traducirFrase(autopausaActiva ? "Guardar" : "Habilitar autopausa")}}
        </button>
        <button class="waves-effect waves-light red btn-small" @click="eliminarAutopausa()">
            {{traducirFrase("Eliminar")}}
        </button>
    </div>
</div>