<?php
    require_once 'Cliente.php';
    class Usuario{
        private $usuario;
        private $nombre;
        private $cliente;
        public function __construct(string $usuario, string $nombre, Cliente $cliente){
            $this->usuario = $usuario;
            $this->nombre = $nombre;
            $this->cliente = $cliente;
        }
        public function getUsuario():string{
            return $this->usuario;            
        }
        public function getNombre():string{
            return $this->nombre;
        }
        public function setNombre(string $nombre):void{
            $this->nombre = $nombre;
        }
        public function getCliente():Cliente{
            return $this->cliente;
        }
        public function setCliente(Cliente $cliente):void{
            $this->cliente = $cliente;
        }
        public function toJSON():array{
            $resp = array();
            $resp["Nombre"] = $this->getNombre();
            $resp["Usuario"] = $this->getUsuario();
            $resp["Cliente"] = ($this->getCliente()!=null?$this->getCliente()->toJSON():null);
            return $resp;
        }
    }
?>