<?php
namespace Encuesta;

require_once 'Encuesta.php';
require_once 'PreguntaDatos.php';
include_once RUTA_APP . 'application/controllers/Clases/ClienteDatos.php';
class EncuestaDatos
{
    public static function getEncuestaById(int $id, $conexion): ?Encuesta
    {
        $respuesta = null;
        if ($stmt = $conexion->prepare("SELECT id_encuesta, nombre, voz, cliente, id_pregunta FROM dialvox_encuestas WHERE id_encuesta = ?")) {
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $stmt->bind_result($id_encuesta, $nombre, $voz, $cliente, $id_pregunta);
            $sePuede = false;
            if ($stmt->fetch()) {
                $sePuede = true;
            }
            $stmt->close();
            if ($sePuede) {
                $respuesta = new Encuesta($id_encuesta, $nombre, $voz, \ClienteDatos::getClienteById($cliente), PreguntaDatos::getPreguntaById($id_pregunta, $conexion));
            }

        }
        return $respuesta;
    }
}
