<?php
    /*
        CREATE TABLE dialvox_crm_gestion_respuesta(
            id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
            Gestion INT NOT NULL,
            Campo INT NOT NULL, 
            Respuesta LONGTEXT
        );
    */
    class Respuesta {
        private $id;
        private $gestion;
        private $campo;
        private $respuesta;
        public function __construct(?int $id, Gestion $gestion, Campo $campo, string $respuesta){
            $this->id = $id;
            $this->gestion = $gestion;
            $this->campo = $campo;
            $this->respuesta = $respuesta;
        }
        public function getId():?int{
            return $this->id;
        }
        public function setId(int $id):void{
            $this->id = $id;
        }
        public function getGestion():?Gestion{
            return $this->gestion;
        }
        public function setGestion(Gestion $gestion):void{
            $this->gestion = $gestion;
        }
        public function getCampo():Campo{
            return $this->campo;
        }
        public function setCampo(Campo $campo):void{
            $this->campo = $campo;
        }
        public function getRespuesta():string{
            return $this->respuesta;
        }
        public function setRespuesta(string $respuesta):void{
            $this->respuesta = $respuesta;
        }
        public function toJSON():array{
            $ret = array();
            $ret["id"] = $this->id;
            $ret["Gestion"] = $this->gestion->toJSON();
            $ret["Campo"] = $this->campo->toJSON();
            $ret["Respuesta"] = $this->respuesta;
            return $ret;
        }
    }
?>