// TODO: Mover a un archivo unificado ==================
/**
 * Function para agregar manejadores a peticiones estandarizadas, deben cumplir con la forma ```{ Estado: "ok" | "error", ...}```
 *
 * @param {Promise} promise Promesa de la peticion
 * @param {(any) => void} cb Callback de exito
 * @param {(mensaje: string) => void} cb_err Callback de error
 */
function manejarPeticionEstandar(promise, cb, cb_err = console.log) {
	promise
		.then(function (r) {
			if (r.Estado === 'ok') {
				cb(r);
			} else {
				cb_err(r.Descripcion);
			}
		})
		.catch(function (e) {
			cb_err(e.message);
		});
}

function prevenirEventoHTML(e) {
	if (e.preventDefault) {
		e.preventDefault();
	}
}

function applyClickListener(id) {
	return function (listener) {
		document.getElementById(id).addEventListener('click', listener);
	};
}
