<?php
$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<section>
	<div class="container mt-2">
		<div class="row">
			<div class="col s12">
				<div class="card">
					<div class="card-content">
						<p>
							<label for='archived'>
								<input type="checkbox" id="archived"/>
								<span>{{traducirFrase("Registros antiguos")}}</span>
							</label>
						</p>
						<p class="red--text text--darken-1">
							{{traducirFrase("Activar esta opcion no es recomendable y generara una gran lentitud en el sistema. Es recomendable activarla cuando no haya agentes")}}
						</p>
					</div>
				</div>
			</div>
			<div class="input-field col s12 m6">
				<label class="active">{{traducirFrase("Agentes")}}</label>
				<select id="selectAgentes" multiple v-model="agentesGami">
					<option value="" disabled selected v-if="agentsSelect.length == 0">{{traducirFrase("No hay agentes")}}</option>
					<option v-for="val in agentsSelect" :value="val.value" selected> {{ val.label }} </option>
				</select>
			</div>
			<div class="input-field col s12 m6">
				<label class="active">{{traducirFrase("Campaña")}}</label>
				<select id="selectCampanas" multiple v-model="campanasGami">
					<option v-for="val in campaignsSelect" :value="val.value"> {{ val.label }} </option>
				</select>
			</div>
			<div class="input-field col s12 m3">
				<label class="active">{{traducirFrase("Estados de calificacion")}}</label>
				<select id="selectStatuses" multiple v-model="estadosGami">
					<option v-for="val in statusesSelect" :value="val.value"> {{ val.label }} </option>
				</select>
			</div>
			<div class="input-field col s12 m3">
				<label class="active">{{traducirFrase("Imagen de grafica")}}</label>
				<select id="selectImagenes" v-model="imagenesGami">
					<option value=""> {{traducirFrase("Sin imagen")}} </option>
					<option :value="'<?=IMG_ADMIN;?>caballo.png'"> {{traducirFrase("Caballos")}} </option>
					<option :value="'<?=IMG_ADMIN;?>carro.png'"> {{traducirFrase("Carros")}} </option>
					<option :value="'<?=IMG_ADMIN;?>corredor.png'"> {{traducirFrase("Corredores")}} </option>
					<option :value="'<?=IMG_ADMIN;?>formula.png'"> {{traducirFrase("Formula 1")}} </option>
					<option :value="'<?=IMG_ADMIN;?>motocicleta.png'"> {{traducirFrase("Motocicletas")}} </option>
					<option :value="'<?=IMG_ADMIN;?>nimbus.png'"> {{traducirFrase("Nimbus 2000")}} </option>
					<option :value="'<?=IMG_ADMIN;?>ciclista.png'"> {{traducirFrase("Bicicletas")}} </option>
				</select>
			</div>
			<div class="input-field col m3">
				<label class="active" for="pickDate1">{{traducirFrase("Fecha")}}</label>
				<input type="text" autocomplete="off" start-date="new Date()" class=" datepicker-here" data-range="true" data-toggle-selected="false" data-multiple-dates-separator=" / " data-date-format="yyyy-mm-dd" data-language="<?=$idioma;?>" class="datepicker-here" id="pickDate"/>
			</div>
			<div class="input-field col s12 m3">
				<input type="number" id="metaGamificacion" v-model="metaGami" min="0">
				<label for="metaGamificacion">{{traducirFrase("Meta")}}</label>
			</div>
			<div class="col s12">
				<label class="active" for="pickDate1">{{traducirFrase("Tiempo de recarga")}}</label>
				<select id="tiemposRecargarGami" class="browser-default tooltipped" style=" margin-top:-5px; " data-position="top"
				:data-tooltip="traducirFrase('Velocidad de recarga')" onchange="cambiaTiempoGami()">
					<option value="-1">{{traducirFrase("Tiempo real")}}</option>
					<option value="2">2s</option>
					<option value="3">3s</option>
					<option value="4">4s</option>
					<option value="5" selected>5s</option>
					<option value="10">10s</option>
					<option value="20">20s</option>
					<option value="30">30s</option>
					<option value="60">1 min</option>
				</select>
			</div>
		</div>
		<div class="row">
			<p>
				<label for="activosGamiId">
					<input type="checkbox" name="activosGamiName" id="activosGamiId" v-model="activosGami">
					<span>{{traducirFrase("Mostrar solo agentes activos")}}</span>
				</label>
			</p>
		</div>
	</div>
</section>
<div class="container">
	<div class="card" style="padding: 1.2rem ;">
		<!-- <div class="progress" v-if="loadingGami">
			<div class="indeterminate"></div>
		</div> -->
		<div v-show="showGami" class="card-content">
			<div class="row container">
				<div
					class="barraCaballo"
					v-for="(val, key) in gamificacionData"
					:style="'z-index: 10;border-color: '+colorsGami[Math.floor(metaCalc(val.count)*10)]+' !important;height:'+(scaleGami*2.5)+'rem !important;'"
				>
					<div class="relleno" :style="styleGami(val.count)">
						<h6 :style="'font-weight: bold;z-index: 400;width: 100%;top: -'+topGami+'%;position: absolute;text-align: right;'">
							{{ val.fullName }}, {{ val.count }}, {{ parseFloat(metaCalc(val.count)*100).toFixed(2)  }} %
						</h6>
					</div>
					<div class="imaCab" :style="'transform: scale('+scaleGami+');'">
						<img
							:src="imagenesGami"
							class="tooltipped"
							:style="'width: 7rem;height: auto;transform: translate(-60%, -8%);position: absolute; top: 30%;filter: hue-rotate('+(colorChange(key))+'deg);'"
							data-position="top"
							:data-tooltip="key+', Llamadas: '+val.count+'.% de meta cumplido: '+parseFloat(metaCalc(val.count)*100).toFixed(2)"
						>
					</div>
				</div>
			</div>
		</div>
		<div class="card-title" v-show="showEmpty">
			{{traducirFrase("No hay informacion que mostrar")}}
		</div>
		<div v-show="loadingGami">
			<div class="barritaAlt">
				<center><img src="<?=IMG_ADMIN;?>spinner.gif"></center>
			</div>
		</div>
	</div>
</div>
