<h4>{{traducirFrase("Pestañas de agente")}}</h4>
<br>
<div class="row px-3">
    <div class="col s12 center-align">
        <button class="btn-small wave-effect waves-light blue white-text" @click="agregarFrameNuevo">
            {{traducirFrase("Agregar pestaña")}}
            <i class="material-icons right">add</i>
        </button>
        <button
            v-if="mostrarEliminarUltimoFrame"
            class="waves-effect waves-light red btn-small"
            @click="eliminarUltimoFrame()"
        >
            {{traducirFrase("Limpiar pestañas sin registrar")}}
        </button>
    </div>
</div>
<div class="row px-3" v-for="(frame, index) in frames" :key="frame.id">
    <div class="col s12">
        <h6>
            {{traducirFrase("Pestaña")}} {{ index + 1 }}
        </h6>
    </div>
    <div class="col s12">
        <div class="row">
            <div class="input-field col s5">
                <input type="text" v-model="frame.titulo">
                <label for="" class="active">{{traducirFrase("Titulo")}}</label>
                <span class="helper-text">
                    {{traducirFrase("Nombre para la pestaña")}}
                </span>
            </div>
            <div class="input-field col s7">
                <input type="text" v-model="frame.urlBase">
                <label for="" class="active">URL</label>
                <span class="helper-text">{{traducirFrase("URL base de la pestaña")}}</span>
            </div>
        </div>
        <div class="row" v-for="variable in frame.variables">
            <div class="input-field col s4">
                <input type="text" v-model="variable.alias">
                <label for="" class="active">{{traducirFrase("Parametro")}}</label>
                <span class="helper-text">
                    {{traducirFrase("Parametro de la URL.")}}
                </span>
            </div>
            <div class="input-field col s6">
                <label for="" class="active">{{traducirFrase("Valor")}}</label>
                <select name="" id="" class="browser-default" v-model="variable.valor">
                    // Closes Issue #497 {
                        <optgroup label="Dialvox">
                            <option :value="''" disabled selected>
                                {{traducirFrase("Selecciona un valor")}}
                            </option>
                            <option
                                v-for="param in framesParametros"
                                :key="param.value"
                                :value="param.value"
                            >
                                {{ param.label }}
                            </option>
                        </optgroup>
                        <optgroup v-for="campo in camposCRM" :label="'CRM ' + campo.grupo">
                            <option
                                v-for="param in campo.campos"
                                :key="param.value"
                                :value="param.value"
                            >
                                {{ param.label }}
                            </option>
                        </optgroup>
					// } Closes Issue #497
                </select>
                <span class="helper-text">
                    {{traducirFrase("Valor de la URL.")}}
                </span>
            </div>
            <div class="input-field col s2">
                <button
                    class="btn-small waves-effect waves-light blue-grey"
                    @click="eliminarVariableDeFrame(frame, variable.valor)"
                >
                    <div class="material-icons">
                        delete
                    </div>
                </button>
            </div>
        </div>
        <div class="row">
            <div class="input-field col s6">
                <input type="text" v-model="frame.variableSiguiente.alias" @keyup.enter="agregarVariable(frame)">
                <label for="" class="active">{{traducirFrase("Parametro")}}</label>
                <span class="helper-text">
                    {{traducirFrase("Parametro de la URL. Presiona enter para confirmar.")}}
                </span>
            </div>
            <div class="input-field col s6">
                <label for="" class="active">{{traducirFrase("Valor")}}</label>
                <select
                    name=""
                    id=""
                    class="browser-default"
                    v-model="frame.variableSiguiente.valor"
                >
                    // Closes Issue #497 {
                    <optgroup label="Dialvox">
                        <option :value="''" disabled selected>
                            {{traducirFrase("Selecciona un valor")}}
                        </option>
                        <option
                            v-for="param in framesParametros"
                            :key="param.value"
                            :value="param.value"
                        >
                            {{ param.label }}
                        </option>
                    </optgroup>
                    <optgroup v-for="campo in camposCRM" :label="'CRM ' + campo.grupo">
                        <option
                            v-for="param in campo.campos"
                            :key="param.value"
                            :value="param.value"
                        >
                            {{ param.label }}
                        </option>
                    </optgroup>
					// } Closes Issue #497
                </select>
                <span class="helper-text">
                    {{traducirFrase("Valor de la URL.")}}
                </span>
            </div>
        </div>
        <div class="row">
            <div class="col s12">
                <p>
                    <label>
                        <input type="checkbox" v-model="frame.estatico" />
                        <span>{{traducirFrase("Pestaña estática")}}</span>
                    </label>
                </p>
            </div>
        </div>
        <div class="row" v-if="frame.id === ''">
            <button class="waves-effect waves-light btn-small" @click="guardarFrame(frame)">
                {{traducirFrase("Guardar")}}
            </button>
        </div>
        <div class="row" v-else>
            <button class="waves-effect waves-light btn-small" @click="editarFrame(frame)">
                {{traducirFrase("Guardar")}}
            </button>
            <button class="waves-effect waves-light red btn-small" @click="eliminarFrame(frame)">
                {{traducirFrase("Eliminar")}}
            </button>
        </div>
    </div>
</div>
