<div class="modal" role="dialog" id="formuModal">
    <div class="modal-dialog" role="document">
        <div class="row" v-if="enviando == true">
            <div class="progress blue lighten-3" style="margin: 0px;">
                <div class="indeterminate blue"></div>
            </div>
        </div>
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{traducirFrase("Registrar audio")}}</h5>
            </div>
            <br>
            <div class="modal-body">
                <div class="row">
                    <div class="input-field col s8 offset-s2">
                        <select id="selectTipoSubida" v-model="valorSelect">
                            <option value="" disabled selected>{{traducirFrase("Seleccion una opcion de subida")}}</option>
                            <option :value="1">{{traducirFrase("Subir archivo de audio")}}</option>
                            <option :value="2">{{traducirFrase("Grabar audio")}}</option>
                        </select>
                        <label for="selectTipoSubida" class="caption">{{traducirFrase("Opcion de subida")}}</label>
                    </div>
                </div>
                <div class="row" v-if="valorSelect == 1">
                    <div class="col s12">
                        <label>{{traducirFrase("Archivo seleccionado")}}</label>
                    </div>
                    <input type="file" id="audioInput" hidden @change="cambiarNombre" accept="audio/*">
                    <div class="input-field col s12">
                        <input type="text" id="archivoAudio" @click="seleccionarAudio" v-model="nombreArchivo" v-bind:placeholder="traducirFrase('Archivo')">
                        <label for="archivoAudio" id="labelNombreAudio"></label>
                    </div>
                    <div class="blue-text col s12">
                        {{traducirFrase("Selecciona un archivo de 5mb o menos")}}
                    </div>
                </div>
                <div class="row" v-if="valorSelect == 2">
                    <div class="row">
                        <div class="col s1 center-align offset-s2">
                            <button
                                class="btn-floating grey lighten-5 btn-flat waves-effect"
                                :disabled="!isRecording"
                                @click="detenGrabacion(0)"
                            >
                                <i class="material-icons" :class="isRecording ? 'red-text' : 'grey-text'">clear</i>
                            </button>
                        </div>
                        <div class="col s6 caption center-align">
                            <button
                                class="btn btn-flat waves-effect blue-grey lighten-5 col s12"
                                style="border-radius: 25px;"
                            >
                                {{time}}
                            </button>
                        </div>
                        <div class="col s1 left-align">
                            <button
                                class="btn-floating btn-flat"
                                :class="isRecording ? 'pulse blue lighten-5':'grey lighten-5'"
                                :disabed="isRecording"
                                @click="!isRecording ? comienzaGrabacion() : null"
                            >
                                <i
                                    class="material-icons"
                                    :class="isRecording ? 'blue-text' : 'teal-text'"
                                >mic_none</i>
                            </button>
                        </div>
                        <div class="col s1 left-align" :hidden="!isRecording">
                            <button
                                class="btn-floating grey lighten-5 btn-flat waves-effect"
                                @click="detenGrabacion(1)"
                            >
                                <i class="material-icons teal-text">play_arrow</i>
                            </button>
                        </div>
                    </div>
                    <div class="row" :hidden="false">
                        <audio controls="controls" class="col s10 offset-s1" id="grabacionAudio"></audio>
                        <div class="col s12">
                            <span class="caption teal-text">
                                {{traducirFrase("Escucha el audio que grabaste antes de enviarlo. Para volver a grabar haz click en el mismo boton grabacion de antes")}}
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row" v-if="valorSelect == ''">
                    <div class="col s8 offset-2">
                        <span class="display-4 caption">
                            {{traducirFrase("Selecciona un forma de subida de audio")}}
                        </span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn waves-effect" @click="enviarAudio()" type='button' v-if="sePuedeEnviar" :disabled="disabled">
                    {{traducirFrase("Enviar")}}
                </button>
                <button class="btn white-text waves-effect" @click="cerrarModal()" type='button'>
                    {{traducirFrase("Cancelar")}}
                </button>
            </div>
        </div>
    </div>
</div>
