<?php
    namespace Encuesta;
    include_once RUTA_APP . 'application/controllers/Clases/Cliente.php'; 
    class Encuesta{
        private int $id;
        private string $nombre;
        private string $voz;
        private \Cliente $cliente;
        private ?Pregunta $preguntaInicial;
        public function __construct(int $id, string $nombre, string $voz, \Cliente $cliente, ?Pregunta $preguntaInicial){
            $this->id = $id;
            $this->nombre = $nombre;
            $this->voz = $voz;
            $this->cliente = $cliente;
            $this->preguntaInicial = $preguntaInicial;
        }
        public function toAssociativeArray():array{
            $resp = array();
            $resp["id"] = $this->id;
            $resp["nombre"] = $this->nombre;
            $resp["voz"] = $this->voz;
            $resp["cliente"] = $this->cliente->toJSON();        
            $resp["preguntaInicial"] = ($this->preguntaInicial != null?$this->preguntaInicial->toAssociativeArray():null);
            return $resp;
        }
        public function getId():int{
            return $this->id;
        }
        public function getCliente():\Cliente{
            return $this->cliente;
        }
        public function getNombre():string{
            return $this->nombre;
        }
    }
?>