$(document).ready(function () {
	$('.modal').modal();
	$('select').formSelect();
});

//-------------------------Chat-----------------------------------

function openForm() {
	document.getElementById('myForm').style.display = 'block';
}

function llenaListaChat() {
	$('#chatSel').append("<option value='1'>Juanito</option>");
	$('#chatSel').append("<option value='2'>Pepe</option>");
	$('#chatSel').append("<option value='3'>Pedro</option>");
	$('#chatSel').append("<option value='4'>Paco</option>");
	$('#chatSel').append("<option value='5'>Jason</option>");

	$('select').formSelect();
}

function closeForm() {
	document.getElementById('myForm').style.display = 'none';
}

//-------------------------Chat-----------------------------------

llenaListaChat();

var app = new Vue({
	el: '#chats',
	data: {
		listaSalasActivas: new Map(),
		mensajesSalasActivas: [],
		salaActiva: '',
		usuarios: [],
		salas: [],
		salaModal: '',

		// Variables para el modal ===============
		modalChat: false, // Para abrir o cerrar el modal
		// se alterna entre verdadero o falso, respectivamente
		nombreSala: '',
		participantesSala: [],
		participantes: [], // Usuarios|participantes que se pueden anadir
		idSala: '',
		// =======================================
	},
	computed: {
		tituloModal: function () {
			return this.idSala == '' ? 'Registrar' : 'Editar';
		},
	},
	methods: {
		// Poner codigo para enviar la info de
		// la sala
		crearSala() {
			if (this.idSala == '') {
				console.log(this.nombreSala, this.participantesSala);
			} else {
				this.idSala = '';
				console.log(this.nombreSala, this.participantesSala);
			}
		},
		// Abre el modal
		abrirModal() {
			this.modalChat = true;
		},
	},
});

const socket = io('https://' + document.domain + ':2021');
socket.on('connect', (data) => {
	socket.emit('firstTime', { usuario: Usuario, socketId: socket.id });
});
socket.on('finallyConnect', (data) => {
	data.Mesajes.forEach((mensaje) => {
		if (app.listaSalasActivas.has(mensaje.sala)) {
			app.mensajesSalasActivas[mensaje.sala].append(mensaje);
		} else {
			app.listaSalasActivas.set(mensaje.sala, mensaje.nombreSala);
			app.mensajesSalasActivas[mensaje.sala] = [mensaje];
		}
	});
});
function agregarUsuarioSala(idSala, usuario) {
	$.post(MODULOS + 'Chat/registerRoom', { sala: idSala, usuario: usuario })
		.done((resp) => {
			if (resp.Estado === 'ok') {
				if (resp.socketId) {
					socket
						.to(resp.socketId)
						.emit('tryJoin', { idSala: idSala });
				} else {
					Swal.fire(
						'Aviso',
						'Por favor haga que la persona recargue la pagina para que pueda unirse a la sala.',
						'info'
					);
				}
			} else {
				console.error(resp);
				Swal.fire('Error', resp.Descripcion, 'error');
			}
		})
		.catch((err) => {
			console.error(err);
		});
}

socket.on('tryJoin', (data) => {
	socket.emit('join', {
		usuario: Usuario,
		socketId: socket.id,
		idSala: data.idSala,
	});
});
socket.on('finallyJoin', (data) => {
	app.listaSalasActivas.set(data.sala, data.nombreSala);
	app.mensajesSalasActivas[data.sala] = [];
	data.Mensajes.forEach((mensaje) => {
		mensaje.sala = data.idSala;
		app.mensajesSalasActivas[mensaje.sala].append(mensaje);
	});
});
socket.on('receive', (data) => {
	app.mensajesSalasActivas[data.Mensaje.sala].append(data.Mensaje);
});
function sendMessage(to, contenido) {
	socket.emit('send', { destinatario: to, contenido: contenido });
}
