(function () {
	window.Dialvox = function ({
		url,
		token,
		onStart,
		onStatusChange,
	}) {
		const self = this;

		const frame = document.createElement('iframe');

		this.__token = token;

		this.__init = (cb, cbstatus) => {
			frame.onload = () => {
				setTimeout(() => {
					frame.contentWindow.postMessage(
						{
							action: 'start',
							token: self.__token,
							getStatus: cbstatus ? true : false,
						},
						url
					);
				}, 1000);
			};

			frame.src = url + '?token=' + self.__token;
			frame.width = 0;
			frame.height = 0;
			frame.allow = 'microphone';
			document.body.appendChild(frame);

			navigator.getMedia =
				navigator.getUserMedia ||
				navigator.webkitGetUserMedia ||
				navigator.mozGetUserMedia;

			navigator.getMedia(
				{ audio: true },
				function () {
					frame.setAttribute('allow', 'microphone');
				},
				function (err) {
					if (self.__catch) self.__catch(err);
				}
			);

			if (cb) self.callback_start = cb;
			if (cbstatus) self.callback_status = cbstatus;
		};

		this.marcacionManual = (numero, cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'dial',
					phone: numero,
				},
				url
			);
			if (cb) self.callback_dial = cb;
		};

		this.preparaMarcarSiguiente = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'dialnextprepare',
				},
				url
			);
			if (cb) self.callback_dialnextprepare = cb;
		};

		this.marcaSiguiente = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'dialnext',
				},
				url
			);
			if (cb) self.callback_dialnext = cb;
		};

		this.califica = (estado, cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'qualification',
					status: estado,
				},
				url
			);
			if (cb) self.callback_qualification = cb;
		};

		this.pausa = (codigo, cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'pause',
					code: codigo,
				},
				url
			);
			if (cb) self.callback_pause = cb;
		};

		this.continua = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'play',
				},
				url
			);
			if (cb) self.callback_play = cb;
		};

		this.cuelga = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'hangup',
				},
				url
			);
			if (cb) self.callback_hangup = cb;
		};

		this.obtenerEstadosCalificacion = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'qualificationstatuses',
					token: self.__token,
				},
				url
			);
			if (cb) self.callback_qualificationstatuses = cb;
		};

		this.obtenerCodigosPausa = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'pausecodes',
					token: self.__token,
				},
				url
			);
			if (cb) self.callback_pausecodes = cb;
		};

		this.__logout = (cb) => {
			frame.contentWindow.postMessage(
				{
					action: 'logout',
					token: self.__token,
				},
				url
			);
			if (cb) self.callback_logout = cb;
		};

		this.logout = (cb) => {
			this.__logout(cb);
			setTimeout(() => {
				frame.remove();
			}, 3000);
		};

		window.addEventListener('message', (evt) => {
			const d = evt.data; // Informacion/contenido del mensaje
			const cb = self['callback_' + d.action];

			if (cb) {
				cb(d.data , self, d);
			}
		});

		this.__init(onStart, onStatusChange);

		return this;
	};
})();
