<script>
    function safe_traducir(frase) {
        return traducirFrase ? traducirFrase(frase) : frase
    }

    // Emite el evento submit al hacer click en el boton de enviar
    Vue.component('multiselect-dialvox', {
        props: {
            value: {
                type: Array,
                default: {}
            }, // Despues determinar el tipo
            options: {
                type: Array,
                default: []
            },
            label: {
                type: String,
                default: safe_traducir("Selecciona una opción")
            },
            sinOpciones: {
                type: String,
                default: safe_traducir("Sin opciones")
            },
            hint: {
                type: String,
                default: safe_traducir("Selecciona una opción")
            },
            sinSelección: {
                type: String,
                default: safe_traducir("Sin selección")
            },
            deselectTodo: {
                type: String,
                default: safe_traducir("De seleccionar todo")
            },
            selectTodo: {
                type: String,
                default: safe_traducir("Seleccionar todo")
            },
            filter: {
                default: ""
            },
            dropdown_id: {
                default: "dropdown_" + Math.random() * 10000
            },
            input_id: {
                default: "input_" + Math.random() * 10000
            },
            filter_id: {
                default: "filter_" + Math.random() * 10000
            },
        },
        data: {

        },
        methods: {
            change: function(newVal) {
                this.$emit("input", newVal)
            },
            deselectAll: function() {
                this.change({})
            },
            selectAll: function() {
                const newVal = {}
                this.filteredOptions.forEach(v => {
                    newVal[v.value] = v.label
                })
                this.change(newVal)
            },
            selectOne: function(value, label) {
                if (this.value[value]) {
                    this.deselectOne(value)
                    return;
                }

                const newVal = Object.assign({}, this.value)
                newVal[value] = label

                console.log(newVal)

                this.change(newVal)
            },
            deselectOne: function(value) {
                const newVal = Object.assign({}, this.value)
                delete newVal[value]

                console.log(newVal)

                this.change(newVal)
            },
            isSelected: function(value) {
                return !!this.value[value]
            },
            changeFilter: function(value) {
                this.$emit("changefilter", value.target.value)
            },
        },
        computed: {
            valueText: function() {
                const text = Object.values(this.value).join(", ")
                if (this.options.length === 0) return safe_traducir("Sin opciones")

                return text
            },
            filteredOptions: function() {
                const regExp = new RegExp(this.filter, "gi")
                return this.options.filter(v => regExp.test(v.label) || this.isSelected(v.value))
            },
            noneSelected() {
                return Object.keys(this.value).length === 0
            },
            allSelected() {
                return Object.keys(this.value).length === this.filteredOptions.length
            }
        },
        template: `<?php echo file_get_contents("template.html", TRUE) ?>`,
        mounted: function() {
            console.log("Se ejecuta el componente", document.querySelectorAll('.dropdown-custom-trigger[data-target="'+this.dropdown_id+'"]'))
            console.log(M.Dropdown.init(document.querySelectorAll('.dropdown-custom-trigger[data-target="'+this.dropdown_id+'"]'), {
                closeOnClick: false,
                hover: false,
            }));
            console.log("Dropdown trigger problematico")
        },
    })
</script>